/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.calib.ConfigChessboard;
import boofcv.abst.calib.ConfigSquareGrid;
import boofcv.abst.calib.PlanarCalibrationDetector;
import boofcv.abst.fiducial.FiducialDetector;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.calibration.PlanarCalibrationTarget;
import boofcv.alg.geo.calibration.Zhang99ComputeTargetHomography;
import boofcv.alg.geo.calibration.Zhang99DecomposeHomography;
import boofcv.core.image.GConvertImage;
import boofcv.factory.calib.FactoryPlanarCalibrationTarget;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class CalibrationFiducialDetector<T extends ImageSingleBand>
implements FiducialDetector<T> {
    PlanarCalibrationDetector detector;
    PlanarCalibrationTarget target;
    Zhang99ComputeTargetHomography computeH;
    Zhang99DecomposeHomography decomposeH = new Zhang99DecomposeHomography();
    DenseMatrix64F K = new DenseMatrix64F(3, 3);
    PointTransform_F64 distortToUndistorted;
    boolean targetDetected;
    Se3_F64 targetToCamera;
    ImageFloat32 converted;
    ImageType<T> type;

    public CalibrationFiducialDetector(ConfigChessboard config, double sizeOfSquares, Class<T> imageType) {
        this.detector = FactoryPlanarCalibrationTarget.detectorChessboard((ConfigChessboard)config);
        this.target = FactoryPlanarCalibrationTarget.gridChess((int)config.numCols, (int)config.numRows, (double)sizeOfSquares);
        this.type = ImageType.single(imageType);
        this.converted = new ImageFloat32(1, 1);
        this.computeH = new Zhang99ComputeTargetHomography(this.target.points);
    }

    public CalibrationFiducialDetector(ConfigSquareGrid config, double sizeOfSquares, Class<T> imageType) {
        this.detector = FactoryPlanarCalibrationTarget.detectorSquareGrid((ConfigSquareGrid)config);
        double spaceWidth = sizeOfSquares * config.spaceToSquareRatio;
        this.target = FactoryPlanarCalibrationTarget.gridSquare((int)config.numCols, (int)config.numRows, (double)sizeOfSquares, (double)spaceWidth);
        this.type = ImageType.single(imageType);
        this.converted = new ImageFloat32(1, 1);
        this.computeH = new Zhang99ComputeTargetHomography(this.target.points);
    }

    @Override
    public void detect(T input) {
        if (input instanceof ImageFloat32) {
            this.converted = (ImageFloat32)input;
        } else {
            this.converted.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            GConvertImage.convert(input, (ImageBase)this.converted);
        }
        if (!this.detector.process(this.converted)) {
            this.targetDetected = false;
            return;
        }
        this.targetDetected = true;
        List points = this.detector.getPoints();
        for (Point2D_F64 p : points) {
            this.distortToUndistorted.compute(p.x, p.y, p);
        }
        if (!this.computeH.computeHomography(points)) {
            this.targetDetected = false;
            return;
        }
        DenseMatrix64F H = this.computeH.getHomography();
        this.decomposeH.setCalibrationMatrix(this.K);
        this.targetToCamera = this.decomposeH.decompose(H);
    }

    @Override
    public void setIntrinsic(IntrinsicParameters intrinsic) {
        this.distortToUndistorted = LensDistortionOps.transformRadialToPixel_F64((IntrinsicParameters)intrinsic);
        PerspectiveOps.calibrationMatrix((IntrinsicParameters)intrinsic, (DenseMatrix64F)this.K);
    }

    @Override
    public int totalFound() {
        return this.targetDetected ? 1 : 0;
    }

    @Override
    public void getFiducialToWorld(int which, Se3_F64 fiducialToSensor) {
        if (which == 0) {
            fiducialToSensor.set(this.targetToCamera);
        }
    }

    @Override
    public int getId(int which) {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.type;
    }

    public List<Point2D_F64> getCalibrationPoints() {
        return this.target.points;
    }
}

