/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.color.ColorHsv;
import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.shapes.RectangleLength2D_I32;

public class LikelihoodHueSatHistInd_U8
implements PixelLikelihood<MultiSpectral<ImageUInt8>> {
    private ImageUInt8 imageRed;
    private ImageUInt8 imageGreen;
    private ImageUInt8 imageBlue;
    private float[] hsv = new float[3];
    private float minimumValue;
    protected float[] binsH;
    protected float[] binsS;
    protected float sizeH;
    protected float sizeS;

    public LikelihoodHueSatHistInd_U8(int maxPixelValue, int numHistogramBins) {
        this.minimumValue = (float)(maxPixelValue + 1) * 0.01f;
        this.binsH = new float[numHistogramBins];
        this.binsS = new float[numHistogramBins];
        this.sizeH = (float)(6.286326899833176 / (double)numHistogramBins);
        this.sizeS = 1.001f / (float)numHistogramBins;
    }

    @Override
    public void setImage(MultiSpectral<ImageUInt8> image) {
        this.imageRed = (ImageUInt8)image.getBand(0);
        this.imageGreen = (ImageUInt8)image.getBand(1);
        this.imageBlue = (ImageUInt8)image.getBand(2);
    }

    public boolean isInBounds(int x, int y) {
        return this.imageRed.isInBounds(x, y);
    }

    @Override
    public void createModel(RectangleLength2D_I32 target) {
        float total = 0.0f;
        for (int y = 0; y < target.height; ++y) {
            int index = this.imageRed.startIndex + (y + target.y0) * this.imageRed.stride + target.x0;
            int x = 0;
            while (x < target.width) {
                int r = this.imageRed.data[index] & 0xFF;
                int g = this.imageGreen.data[index] & 0xFF;
                int b = this.imageBlue.data[index] & 0xFF;
                ColorHsv.rgbToHsv((float)r, (float)g, (float)b, (float[])this.hsv);
                if (!(this.hsv[2] < this.minimumValue)) {
                    int n = (int)(this.hsv[0] / this.sizeH);
                    this.binsH[n] = this.binsH[n] + 1.0f;
                    int n2 = (int)(this.hsv[1] / this.sizeS);
                    this.binsS[n2] = this.binsS[n2] + 1.0f;
                    total += 1.0f;
                }
                ++x;
                ++index;
            }
        }
        int i = 0;
        while (i < this.binsH.length) {
            int n = i;
            this.binsH[n] = this.binsH[n] / total;
            int n3 = i++;
            this.binsS[n3] = this.binsS[n3] / total;
        }
    }

    public float compute(int x, int y) {
        int index = this.imageRed.getIndex(x, y);
        int r = this.imageRed.data[index] & 0xFF;
        int g = this.imageGreen.data[index] & 0xFF;
        int b = this.imageBlue.data[index] & 0xFF;
        ColorHsv.rgbToHsv((float)r, (float)g, (float)b, (float[])this.hsv);
        if (this.hsv[2] < this.minimumValue) {
            return 0.0f;
        }
        return this.binsH[(int)(this.hsv[0] / this.sizeH)] * this.binsS[(int)(this.hsv[1] / this.sizeS)];
    }
}

