/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.core.net.AbstractSendEmail;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.NullToken;
import adams.flow.sink.AbstractSink;
import adams.flow.sink.SendEmail;
import adams.flow.standalone.SMTPConnection;
import adams.flow.transformer.CreateEmail;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;

@Deprecated
public class Email
extends AbstractSink {
    private static final long serialVersionUID = -5959868605503747649L;
    protected EmailAddress m_Sender;
    protected EmailAddress[] m_Recipients;
    protected EmailAddress[] m_CC;
    protected EmailAddress[] m_BCC;
    protected String m_Subject;
    protected BaseText m_Body;
    protected BaseText m_Signature;
    protected AbstractSendEmail m_SendEmail;
    protected boolean m_Queue;
    protected List<SwingWorker> m_Sending;

    public String globalInfo() {
        return "Actor for sending emails. The (optional) attachments are taken from the input.\nVariables in 'subject', 'body' and 'signature' are automatically replaced whenever the actor is executed.\n" + (EmailHelper.isEnabled() ? "" : "Email support not enabled, check email setup!") + "\n\n" + "Deprecated: Use " + CreateEmail.class.getName() + " and " + SendEmail.class.getName() + " instead";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sender", "sender", (Object)new EmailAddress(EmailHelper.getDefaultFromAddress()), false);
        this.m_OptionManager.add("recipient", "recipients", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("cc", "CC", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("bcc", "BCC", (Object)new EmailAddress[0]);
        this.m_OptionManager.add("subject", "subject", (Object)"");
        this.m_OptionManager.add("body", "body", (Object)new BaseText(""));
        this.m_OptionManager.add("signature", "signature", (Object)new BaseText(Utils.unbackQuoteChars((String)EmailHelper.getDefaultSignature())));
        this.m_OptionManager.add("send-email", "sendEmail", (Object)EmailHelper.getDefaultSendEmail());
        this.m_OptionManager.add("queue", "queue", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Sending = new ArrayList<SwingWorker>();
    }

    public String getQuickInfo() {
        if (!EmailHelper.isEnabled()) {
            return "No email support enabled, check email setup!";
        }
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"sender", (Object)((Object)this.m_Sender), (String)"From: ");
        String value = this.m_Recipients != null && this.m_Recipients.length > 0 ? Utils.flatten((Object[])this.m_Recipients, (String)", ") : "<no recipients>";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"recipients", (Object)value, (String)", To: ");
        value = this.m_CC != null && this.m_CC.length > 0 ? Utils.flatten((Object[])this.m_CC, (String)", ") : null;
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"CC", (Object)value, (String)", CC: ")) != null) {
            result = result + value;
        }
        value = this.m_BCC != null && this.m_BCC.length > 0 ? Utils.flatten((Object[])this.m_BCC, (String)", ") : null;
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"BCC", (Object)value, (String)", BCC: ")) != null) {
            result = result + value;
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sendEmail", ((Object)((Object)this.m_SendEmail)).getClass(), (String)", send: ");
        value = QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (boolean)this.m_Queue, (String)"queue", (String)",");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setSender(EmailAddress value) {
        this.m_Sender = value;
        this.reset();
    }

    public EmailAddress getSender() {
        return this.m_Sender;
    }

    public String senderTipText() {
        return "The sender address to use.";
    }

    public void setRecipients(EmailAddress[] value) {
        this.m_Recipients = value;
        this.reset();
    }

    public EmailAddress[] getRecipients() {
        return this.m_Recipients;
    }

    public String recipientsTipText() {
        return "The recipients to send the email to.";
    }

    public void setCC(EmailAddress[] value) {
        this.m_CC = value;
        this.reset();
    }

    public EmailAddress[] getCC() {
        return this.m_CC;
    }

    public String CCTipText() {
        return "The CC recipients to send the email to.";
    }

    public void setBCC(EmailAddress[] value) {
        this.m_BCC = value;
        this.reset();
    }

    public EmailAddress[] getBCC() {
        return this.m_BCC;
    }

    public String BCCTipText() {
        return "The BCC recipients to send the email to.";
    }

    public void setSubject(String value) {
        this.m_Subject = value;
        this.reset();
    }

    public String getSubject() {
        return this.m_Subject;
    }

    public String subjectTipText() {
        return "The subject of the email.";
    }

    public void setBody(BaseText value) {
        this.m_Body = value;
        this.reset();
    }

    public BaseText getBody() {
        return this.m_Body;
    }

    public String bodyTipText() {
        return "The body of the email.";
    }

    public void setSignature(BaseText value) {
        this.m_Signature = value;
        this.reset();
    }

    public BaseText getSignature() {
        return this.m_Signature;
    }

    public String signatureTipText() {
        return "The signature of the email, gets separated by an extra line consisting of '--'.";
    }

    public void setSendEmail(AbstractSendEmail value) {
        this.m_SendEmail = value;
        this.reset();
    }

    public AbstractSendEmail getSendEmail() {
        return this.m_SendEmail;
    }

    public String sendEmailTipText() {
        return "The engine for sending the emails.";
    }

    public void setQueue(boolean value) {
        this.m_Queue = value;
        this.reset();
    }

    public boolean getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "Whether to queue the emails rather than waiting for them to be sent.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !EmailHelper.isEnabled()) {
            result = "No email support enabled, check email setup!";
        }
        if (result == null && !QuickInfoHelper.hasVariable((OptionHandler)this, (String)"recipients") && this.m_Recipients.length == 0) {
            result = "At least one email recipient must be defined!";
        }
        return result;
    }

    protected void initSession() throws Exception {
        if (this.m_SendEmail.requiresSmtpSessionInitialization()) {
            SMTPConnection conn = (SMTPConnection)ActorUtils.findClosestType((AbstractActor)this, SMTPConnection.class, (boolean)true);
            if (conn != null) {
                conn.initializeSmtpSession(this.m_SendEmail);
            } else {
                this.m_SendEmail.initializeSmtpSession(EmailHelper.getSmtpServer(), EmailHelper.getSmtpPort(), EmailHelper.getSmtpStartTLS(), EmailHelper.getSmtpTimeout(), EmailHelper.getSmtpRequiresAuthentication(), EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword());
            }
        }
    }

    protected String doExecute() {
        File[] attachments;
        String result = null;
        if (this.m_InputToken == null || this.m_InputToken instanceof NullToken) {
            attachments = new File[]{};
        } else if (this.m_InputToken.getPayload() instanceof File) {
            attachments = new File[]{(File)this.m_InputToken.getPayload()};
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            attachments = (File[])this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            attachments = new File[]{new PlaceholderFile((String)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            attachments = new File[((String[])this.m_InputToken.getPayload()).length];
            for (int i = 0; i < attachments.length; ++i) {
                attachments[i] = new PlaceholderFile(((String[])this.m_InputToken.getPayload())[i]);
            }
        } else {
            attachments = null;
        }
        String subject = this.getVariables().expand(this.m_Subject);
        String body = EmailHelper.combine(this.getVariables().expand(this.m_Body.getValue()), this.getVariables().expand(this.m_Signature.getValue()));
        final adams.core.net.Email email = new adams.core.net.Email(this.m_Sender, this.m_Recipients, this.m_CC, this.m_BCC, subject, body, attachments);
        if (this.isLoggingEnabled()) {
            this.getLogger().info(email.toString());
        }
        if (this.m_Queue) {
            SwingWorker run = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    try {
                        Email.this.initSession();
                        if (!Email.this.m_SendEmail.sendMail(email)) {
                            Email.this.m_Self.handleError(Email.this.m_Self, "email", "Failed to send email, check console output!");
                        }
                    }
                    catch (Exception e) {
                        Utils.handleException((LoggingObject)Email.this.m_Self, (String)"Failed to send email: ", (Throwable)e);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    Email.this.m_Sending.remove(this);
                    super.done();
                }
            };
            this.m_Sending.add(run);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Queuing email, queue size: " + this.m_Sending.size());
            }
            run.execute();
        } else {
            try {
                this.initSession();
                if (!this.m_SendEmail.sendMail(email)) {
                    result = "Failed to send email, check console output!";
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to send email: ", e);
            }
        }
        return result;
    }

    public void stopExecution() {
        this.m_Sending.clear();
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        while (this.m_Sending.size() > 0 && !this.m_Stopped) {
            try {
                Email email = this;
                synchronized (email) {
                    ((Object)((Object)this)).wait(100L);
                }
            }
            catch (Exception exception) {
            }
        }
        super.wrapUp();
    }
}

