/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.RotationMatrixGenerator;
import georegression.geometry.UtilPoint3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Quaternion;
import java.util.List;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;

public class MotionSe3PointCrossCovariance_F64
implements MotionTransformPoint<Se3_F64, Point3D_F64> {
    private double[] param = new double[7];
    private Se3_F64 motion = new Se3_F64();
    private Quaternion quat = new Quaternion();

    public double[] getParam() {
        return this.param;
    }

    @Override
    public Se3_F64 getMotion() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point3D_F64> fromPts, List<Point3D_F64> toPts) {
        if (fromPts.size() != toPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        Point3D_F64 meanFrom = UtilPoint3D_F64.mean(fromPts);
        Point3D_F64 meanTo = UtilPoint3D_F64.mean(toPts);
        int N = fromPts.size();
        double s11 = 0.0;
        double s12 = 0.0;
        double s13 = 0.0;
        double s21 = 0.0;
        double s22 = 0.0;
        double s23 = 0.0;
        double s31 = 0.0;
        double s32 = 0.0;
        double s33 = 0.0;
        double m11 = meanFrom.x * meanTo.x;
        double m12 = meanFrom.x * meanTo.y;
        double m13 = meanFrom.x * meanTo.z;
        double m21 = meanFrom.y * meanTo.x;
        double m22 = meanFrom.y * meanTo.y;
        double m23 = meanFrom.y * meanTo.z;
        double m31 = meanFrom.z * meanTo.x;
        double m32 = meanFrom.z * meanTo.y;
        double m33 = meanFrom.z * meanTo.z;
        for (int i = 0; i < N; ++i) {
            Point3D_F64 f = fromPts.get(i);
            Point3D_F64 t = toPts.get(i);
            s11 += f.x * t.x;
            s12 += f.x * t.y;
            s13 += f.x * t.z;
            s21 += f.y * t.x;
            s22 += f.y * t.y;
            s23 += f.y * t.z;
            s31 += f.z * t.x;
            s32 += f.z * t.y;
            s33 += f.z * t.z;
        }
        s11 = s11 / (double)N - m11;
        s12 = s12 / (double)N - m12;
        s13 = s13 / (double)N - m13;
        s21 = s21 / (double)N - m21;
        s22 = s22 / (double)N - m22;
        s23 = s23 / (double)N - m23;
        s31 = s31 / (double)N - m31;
        s32 = s32 / (double)N - m32;
        s33 = s33 / (double)N - m33;
        SimpleMatrix Sigma = new SimpleMatrix(3, 3, true, new double[]{s11, s12, s13, s21, s22, s23, s31, s32, s33});
        SimpleMatrix Delta = new SimpleMatrix(3, 1, true, new double[]{s23 - s32, s31 - s13, s12 - s21});
        SimpleMatrix Q = new SimpleMatrix(4, 4);
        SimpleMatrix BR = (SimpleMatrix)((SimpleMatrix)Sigma.plus(Sigma.transpose())).minus(SimpleMatrix.identity((int)3).scale(Sigma.trace()));
        Q.set(0, 0, Sigma.trace());
        Q.insertIntoThis(0, 1, Delta.transpose());
        Q.insertIntoThis(1, 0, (SimpleBase)Delta);
        Q.insertIntoThis(1, 1, (SimpleBase)BR);
        this.extractQuaternionFromQ(Q);
        GeometryMath_F64.mult(this.motion.getR(), meanFrom, meanFrom);
        Vector3D_F64 T = this.motion.getT();
        this.param[4] = T.x = meanTo.x - meanFrom.x;
        this.param[5] = T.y = meanTo.y - meanFrom.y;
        this.param[6] = T.z = meanTo.z - meanFrom.z;
        return true;
    }

    private void extractQuaternionFromQ(SimpleMatrix q) {
        SimpleEVD evd = q.eig();
        int indexMax = evd.getIndexMax();
        SimpleMatrix v_max = evd.getEigenVector(indexMax);
        this.quat.q1 = v_max.get(0);
        this.quat.q2 = v_max.get(1);
        this.quat.q3 = v_max.get(2);
        this.quat.q4 = v_max.get(3);
        this.quat.normalize();
        RotationMatrixGenerator.quaternionToMatrix(this.quat, this.motion.getR());
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

