/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point3D_F32;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UtilPoint3D_F32 {
    public static float distance(float x0, float y0, float z0, float x1, float y1, float z1) {
        return UtilPoint3D_F32.norm(x1 - x0, y1 - y0, z1 - z0);
    }

    public static float distanceSq(float x0, float y0, float z0, float x1, float y1, float z1) {
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        return dx * dx + dy * dy + dz * dz;
    }

    public static float norm(float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static List<Point3D_F32> copy(List<Point3D_F32> pts) {
        ArrayList<Point3D_F32> ret = new ArrayList<Point3D_F32>();
        for (Point3D_F32 p : pts) {
            ret.add(p.copy());
        }
        return ret;
    }

    public static void noiseNormal(List<Point3D_F32> pts, float sigma, Random rand) {
        for (Point3D_F32 p : pts) {
            p.x += (float)rand.nextGaussian() * sigma;
            p.y += (float)rand.nextGaussian() * sigma;
            p.z += (float)rand.nextGaussian() * sigma;
        }
    }

    public static List<Point3D_F32> random(float min, float max, int num, Random rand) {
        ArrayList<Point3D_F32> ret = new ArrayList<Point3D_F32>();
        float d = max - min;
        for (int i = 0; i < num; ++i) {
            Point3D_F32 p = new Point3D_F32();
            p.x = rand.nextFloat() * d + min;
            p.y = rand.nextFloat() * d + min;
            p.z = rand.nextFloat() * d + min;
            ret.add(p);
        }
        return ret;
    }

    public static Point3D_F32 mean(List<Point3D_F32> points) {
        Point3D_F32 mean = new Point3D_F32();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (Point3D_F32 p : points) {
            x += p.x;
            y += p.y;
            z += p.z;
        }
        mean.x = x / (float)points.size();
        mean.y = y / (float)points.size();
        mean.z = z / (float)points.size();
        return mean;
    }

    public static Point3D_F32 mean(List<Point3D_F32> points, int num) {
        Point3D_F32 mean = new Point3D_F32();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = 0; i < num; ++i) {
            Point3D_F32 p = points.get(i);
            x += p.x;
            y += p.y;
            z += p.z;
        }
        mean.x = x / (float)num;
        mean.y = y / (float)num;
        mean.z = z / (float)num;
        return mean;
    }
}

