/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.fitting.ellipse.ClosestPointEllipseAngle_F32;
import georegression.misc.GrlConstants;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.EllipseRotated_F32;

public class ClosestPoint2D_F32 {
    public static Point2D_F32 closestPoint(LineParametric2D_F32 line, Point2D_F32 p, Point2D_F32 storage) {
        if (storage == null) {
            storage = new Point2D_F32();
        }
        float t = ClosestPoint2D_F32.closestPointT(line, p);
        storage.x = line.p.x + line.slope.x * t;
        storage.y = line.p.y + line.slope.y * t;
        return storage;
    }

    public static float closestPointT(LineParametric2D_F32 line, Point2D_F32 p) {
        float t = line.slope.x * (p.x - line.p.x) + line.slope.y * (p.y - line.p.y);
        return t /= line.slope.x * line.slope.x + line.slope.y * line.slope.y;
    }

    public static Point2D_F32 closestPoint(EllipseRotated_F32 ellipse, Point2D_F32 p) {
        ClosestPointEllipseAngle_F32 alg = new ClosestPointEllipseAngle_F32(GrlConstants.FLOAT_TEST_TOL, 30);
        alg.setEllipse(ellipse);
        alg.process(p);
        return alg.getClosest();
    }
}

