/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.fitting.ellipse.ClosestPointEllipseAngle_F64;
import georegression.misc.GrlConstants;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseRotated_F64;

public class ClosestPoint2D_F64 {
    public static Point2D_F64 closestPoint(LineParametric2D_F64 line, Point2D_F64 p, Point2D_F64 storage) {
        if (storage == null) {
            storage = new Point2D_F64();
        }
        double t = ClosestPoint2D_F64.closestPointT(line, p);
        storage.x = line.p.x + line.slope.x * t;
        storage.y = line.p.y + line.slope.y * t;
        return storage;
    }

    public static double closestPointT(LineParametric2D_F64 line, Point2D_F64 p) {
        double t = line.slope.x * (p.x - line.p.x) + line.slope.y * (p.y - line.p.y);
        return t /= line.slope.x * line.slope.x + line.slope.y * line.slope.y;
    }

    public static Point2D_F64 closestPoint(EllipseRotated_F64 ellipse, Point2D_F64 p) {
        ClosestPointEllipseAngle_F64 alg = new ClosestPointEllipseAngle_F64(GrlConstants.DOUBLE_TEST_TOL, 30);
        alg.setEllipse(ellipse);
        alg.process(p);
        return alg.getClosest();
    }
}

