/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.metric.MiscOps;
import georegression.struct.line.LineParametric3D_F32;
import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;

public class ClosestPoint3D_F32 {
    public static Point3D_F32 closestPoint(LineParametric3D_F32 l0, LineParametric3D_F32 l1, Point3D_F32 ret) {
        if (ret == null) {
            ret = new Point3D_F32();
        }
        ret.x = l0.p.x - l1.p.x;
        ret.y = l0.p.y - l1.p.y;
        ret.z = l0.p.z - l1.p.z;
        float dv01v1 = MiscOps.dot(ret, l1.slope);
        float dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        float dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        float t0 = dv01v1 * dv1v0 - MiscOps.dot(ret, l0.slope) * dv1v1;
        float bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        if (bottom == 0.0f) {
            return null;
        }
        float t1 = (dv01v1 + (t0 /= bottom) * dv1v0) / dv1v1;
        ret.x = 0.5f * (l0.p.x + t0 * l0.slope.x + (l1.p.x + t1 * l1.slope.x));
        ret.y = 0.5f * (l0.p.y + t0 * l0.slope.y + (l1.p.y + t1 * l1.slope.y));
        ret.z = 0.5f * (l0.p.z + t0 * l0.slope.z + (l1.p.z + t1 * l1.slope.z));
        return ret;
    }

    public static boolean closestPoints(LineParametric3D_F32 l0, LineParametric3D_F32 l1, float[] param) {
        float dX = l0.p.x - l1.p.x;
        float dY = l0.p.y - l1.p.y;
        float dZ = l0.p.z - l1.p.z;
        float dv01v1 = MiscOps.dot(dX, dY, dZ, l1.slope);
        float dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        float dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        float t0 = dv01v1 * dv1v0 - MiscOps.dot(dX, dY, dZ, l0.slope) * dv1v1;
        float bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        if (bottom == 0.0f) {
            return false;
        }
        float t1 = (dv01v1 + (t0 /= bottom) * dv1v0) / dv1v1;
        param[0] = t0;
        param[1] = t1;
        return true;
    }

    public static Point3D_F32 closestPoint(LineParametric3D_F32 line, Point3D_F32 pt, Point3D_F32 ret) {
        if (ret == null) {
            ret = new Point3D_F32();
        }
        Vector3D_F32 ab = new Vector3D_F32(line.p, pt);
        float n = line.slope.norm();
        float d = line.slope.dot(ab) / n;
        ret.x = line.p.x + d * line.slope.x / n;
        ret.y = line.p.y + d * line.slope.y / n;
        ret.z = line.p.z + d * line.slope.z / n;
        return ret;
    }

    public static Point3D_F32 closestPoint(PlaneGeneral3D_F32 plane, Point3D_F32 point, Point3D_F32 found) {
        if (found == null) {
            found = new Point3D_F32();
        }
        float top = plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
        float n2 = plane.A * plane.A + plane.B * plane.B + plane.C * plane.C;
        found.x = point.x - plane.A * top / n2;
        found.y = point.y - plane.B * top / n2;
        found.z = point.z - plane.C * top / n2;
        return found;
    }
}

