/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilPoint3D_F64;
import georegression.metric.MiscOps;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.plane.PlaneGeneral3D_F64;
import georegression.struct.point.Point3D_F64;

public class Distance3D_F64 {
    public static double distance(LineParametric3D_F64 l0, LineParametric3D_F64 l1) {
        double x = l0.p.x - l1.p.x;
        double y = l0.p.y - l1.p.y;
        double z = l0.p.z - l1.p.z;
        double dv01v1 = MiscOps.dot(x, y, z, l1.slope);
        double dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        double dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        double bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        double t0 = bottom == 0.0 ? 0.0 : (dv01v1 * dv1v0 - MiscOps.dot(x, y, z, l0.slope) * dv1v1) / bottom;
        double t1 = (dv01v1 + t0 * dv1v0) / dv1v1;
        double dx = l0.p.x + t0 * l0.slope.x - (l1.p.x + t1 * l1.slope.x);
        double dy = l0.p.y + t0 * l0.slope.y - (l1.p.y + t1 * l1.slope.y);
        double dz = l0.p.z + t0 * l0.slope.z - (l1.p.z + t1 * l1.slope.z);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distance(LineParametric3D_F64 l, Point3D_F64 p) {
        double x = l.p.x - p.x;
        double y = l.p.y - p.y;
        double z = l.p.z - p.z;
        double c = UtilPoint3D_F64.norm(x, y, z);
        double b = MiscOps.dot(x, y, z, l.slope) / l.slope.norm();
        return Math.sqrt(c * c - b * b);
    }

    public static double distance(PlaneGeneral3D_F64 plane, Point3D_F64 point) {
        double top = plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
        return top / Math.sqrt(plane.A * plane.A + plane.B * plane.B + plane.C * plane.C);
    }
}

