/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F64;

public abstract class GeoTuple3D_F64<T extends GeoTuple3D_F64>
extends GeoTuple_F64<T> {
    public double x;
    public double y;
    public double z;

    public GeoTuple3D_F64(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public GeoTuple3D_F64() {
    }

    @Override
    public int getDimension() {
        return 3;
    }

    protected void _set(GeoTuple3D_F64 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean isIdentical(double x, double y, double z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public boolean isIdentical(double x, double y, double z, double tol) {
        return Math.abs(this.x - x) <= tol && Math.abs(this.y - y) <= tol && Math.abs(this.z - z) <= tol;
    }

    @Override
    public boolean isIdentical(GeoTuple3D_F64 t, double tol) {
        return Math.abs(this.x - t.x) <= tol && Math.abs(this.y - t.y) <= tol && Math.abs(this.z - t.z) <= tol;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Override
    public double getIndex(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIndex(int index, double value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    @Override
    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double normSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void scale(double value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
    }

    @Override
    public double distance(GeoTuple3D_F64 t) {
        double dx = t.x - this.x;
        double dy = t.y - this.y;
        double dz = t.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double distance2(GeoTuple3D_F64 t) {
        double dx = t.x - this.x;
        double dy = t.y - this.y;
        double dz = t.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void print() {
        System.out.println(this);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }
}

