/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F32;

public abstract class GeoTuple4D_F32<T extends GeoTuple4D_F32>
extends GeoTuple_F32<T> {
    public float x;
    public float y;
    public float z;
    public float w;

    public GeoTuple4D_F32(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public GeoTuple4D_F32() {
    }

    @Override
    public int getDimension() {
        return 4;
    }

    protected void _set(GeoTuple4D_F32 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.w = a.w;
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public boolean isIdentical(float x, float y, float z, float w) {
        return this.x == x && this.y == y && this.z == z && this.w == w;
    }

    public boolean isIdentical(float x, float y, float z, float w, float tol) {
        return Math.abs(this.x - x) <= tol && Math.abs(this.y - y) <= tol && Math.abs(this.z - z) <= tol && Math.abs(this.w - w) <= tol;
    }

    @Override
    public boolean isIdentical(GeoTuple4D_F32 t, float tol) {
        return Math.abs(this.x - t.x) <= tol && Math.abs(this.y - t.y) <= tol && Math.abs(this.z - t.z) <= tol && Math.abs(this.w - t.w) <= tol;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    @Override
    public float getIndex(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIndex(int index, float value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.w = value;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    @Override
    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    @Override
    public float normSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @Override
    public float distance(GeoTuple4D_F32 t) {
        float dx = t.x - this.x;
        float dy = t.y - this.y;
        float dz = t.z - this.z;
        float dw = t.w - this.w;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    @Override
    public float distance2(GeoTuple4D_F32 t) {
        float dx = t.x - this.x;
        float dy = t.y - this.y;
        float dz = t.z - this.z;
        float dw = t.w - this.w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public void print() {
        System.out.println(this);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z) || Float.isNaN(this.w);
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setW(float w) {
        this.w = w;
    }
}

