/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.struct.InvertibleTransform;
import georegression.struct.se.SpecialEuclidean;
import java.util.ArrayList;
import java.util.List;

public class InvertibleTransformSequence {
    private List<Node> path = new ArrayList<Node>();

    public void addTransform(boolean forward, SpecialEuclidean tran) {
        this.path.add(new Node(tran, forward));
    }

    public void clear() {
        this.path.clear();
    }

    public void computeTransform(SpecialEuclidean result) {
        if (this.path.size() == 0) {
            return;
        }
        InvertibleTransform tmp0 = result.createInstance();
        Object tmp1 = result.createInstance();
        Object inv = result.createInstance();
        Node n = this.path.get(0);
        InvertibleTransform nodeTran = n.tran;
        if (n.forward) {
            tmp0.set((InvertibleTransform)nodeTran);
        } else {
            nodeTran.invert(tmp0);
        }
        for (int i = 1; i < this.path.size(); ++i) {
            n = this.path.get(i);
            nodeTran = n.tran;
            if (n.forward) {
                tmp0.concat((InvertibleTransform)nodeTran, tmp1);
            } else {
                nodeTran.invert(inv);
                tmp0.concat(inv, tmp1);
            }
            InvertibleTransform swap = tmp0;
            tmp0 = tmp1;
            tmp1 = swap;
        }
        result.set(tmp0);
    }

    public List<Node> getPath() {
        return this.path;
    }

    public static class Node {
        public InvertibleTransform tran;
        public boolean forward;

        public Node(InvertibleTransform tran, boolean forward) {
            this.tran = tran;
            this.forward = forward;
        }
    }
}

