/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.so;

import georegression.struct.point.Vector3D_F64;

public class Rodrigues {
    public Vector3D_F64 unitAxisRotation = new Vector3D_F64();
    public double theta;

    public Rodrigues() {
    }

    public Rodrigues(double theta, Vector3D_F64 unitAxisRotation) {
        this.theta = theta;
        this.unitAxisRotation.set(unitAxisRotation);
    }

    public Rodrigues(double theta, double x, double y, double z) {
        this.theta = theta;
        this.unitAxisRotation.set(x, y, z);
        this.unitAxisRotation.normalize();
    }

    public Vector3D_F64 getUnitAxisRotation() {
        return this.unitAxisRotation;
    }

    public void setUnitAxisRotation(Vector3D_F64 unitAxisRotation) {
        this.unitAxisRotation.set(unitAxisRotation);
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public void setParamVector(double x, double y, double z) {
        double ax = Math.abs(x);
        double ay = Math.abs(y);
        double az = Math.abs(z);
        double max = Math.max(ax, ay);
        if ((max = Math.max(max, az)) == 0.0) {
            this.theta = 0.0;
            this.unitAxisRotation.set(1.0, 0.0, 0.0);
        } else {
            this.theta = Math.sqrt((x /= max) * x + (y /= max) * y + (z /= max) * z);
            this.unitAxisRotation.x = x / this.theta;
            this.unitAxisRotation.y = y / this.theta;
            this.unitAxisRotation.z = z / this.theta;
            this.theta *= max;
        }
    }
}

