/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform;

import georegression.struct.InvertibleTransform;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.homo.Homography2D_F64;
import georegression.struct.se.Se2_F64;

public class ConvertTransform_F64 {
    public static <A extends InvertibleTransform, B extends InvertibleTransform> B convert(A src, B dst) {
        if (src == null || dst == null) {
            throw new IllegalArgumentException("Both inputs must not be null");
        }
        if (src instanceof Se2_F64) {
            if (dst instanceof Affine2D_F64) {
                return (B)ConvertTransform_F64.convert((Se2_F64)src, (Affine2D_F64)dst);
            }
            if (dst instanceof Homography2D_F64) {
                return (B)ConvertTransform_F64.convert((Se2_F64)src, (Homography2D_F64)dst);
            }
            if (dst instanceof Se2_F64) {
                dst.set(src);
                return dst;
            }
        } else if (src instanceof Affine2D_F64) {
            if (dst instanceof Homography2D_F64) {
                return (B)ConvertTransform_F64.convert((Affine2D_F64)src, (Homography2D_F64)dst);
            }
            if (dst instanceof Affine2D_F64) {
                dst.set(src);
                return dst;
            }
        } else if (src instanceof Homography2D_F64 && dst instanceof Homography2D_F64) {
            dst.set(src);
            return dst;
        }
        throw new IllegalArgumentException("The specified transform is not supported");
    }

    public static Affine2D_F64 convert(Se2_F64 src, Affine2D_F64 dst) {
        if (dst == null) {
            dst = new Affine2D_F64();
        }
        dst.a11 = src.c;
        dst.a12 = -src.s;
        dst.a21 = src.s;
        dst.a22 = src.c;
        dst.tx = src.T.x;
        dst.ty = src.T.y;
        return dst;
    }

    public static Homography2D_F64 convert(Se2_F64 src, Homography2D_F64 dst) {
        if (dst == null) {
            dst = new Homography2D_F64();
        }
        dst.a11 = src.c;
        dst.a12 = -src.s;
        dst.a13 = src.T.x;
        dst.a21 = src.s;
        dst.a22 = src.c;
        dst.a23 = src.T.y;
        dst.a31 = 0.0;
        dst.a32 = 0.0;
        dst.a33 = 1.0;
        return dst;
    }

    public static Homography2D_F64 convert(Affine2D_F64 src, Homography2D_F64 dst) {
        if (dst == null) {
            dst = new Homography2D_F64();
        }
        dst.a11 = src.a11;
        dst.a12 = src.a12;
        dst.a13 = src.tx;
        dst.a21 = src.a21;
        dst.a22 = src.a22;
        dst.a23 = src.ty;
        dst.a31 = 0.0;
        dst.a32 = 0.0;
        dst.a33 = 1.0;
        return dst;
    }
}

