/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.MutableActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;
import adams.flow.source.WekaClustererSetup;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.WekaClusterer;
import adams.flow.transformer.WekaTrainClusterer;
import java.util.List;

public class FixDeprecatedWekaClusterer
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = -4170658262349662939L;

    public String globalInfo() {
        return "Replaces the WekaClusterer transformer with WekaClustererSetup and WekaTrainClusterer instances";
    }

    protected void processActor(AbstractActor actor) {
        List clusterers = ActorUtils.enumerate((AbstractActor)actor, (Class[])new Class[]{WekaClusterer.class});
        for (AbstractActor clusterer : clusterers) {
            WekaClusterer cactor = (WekaClusterer)clusterer;
            String var = cactor.getOptionManager().getVariableForProperty("clusterer");
            if (cactor.getParent() instanceof GlobalActors) {
                WekaClustererSetup setup = new WekaClustererSetup();
                setup.setClusterer(cactor.getClusterer());
                if (var != null) {
                    setup.getOptionManager().setVariableForProperty("clusterer", var);
                }
                setup.setName(cactor.getName());
                ((MutableActorHandler)cactor.getParent()).set(cactor.index(), (AbstractActor)setup);
                this.m_Modified = true;
                continue;
            }
            GlobalActors global = GlobalActorHelper.createGlobalActors((AbstractActor)cactor, (boolean)true);
            WekaClustererSetup setup = new WekaClustererSetup();
            setup.setClusterer(cactor.getClusterer());
            if (var != null) {
                setup.getOptionManager().setVariableForProperty("clusterer", var);
            }
            global.add((AbstractActor)setup);
            WekaTrainClusterer train = new WekaTrainClusterer();
            train.setClusterer(new GlobalActorReference(setup.getName()));
            train.setName(cactor.getName());
            ((MutableActorHandler)cactor.getParent()).set(cactor.index(), (AbstractActor)train);
            this.m_Modified = true;
        }
    }
}

