/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Level;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.CostCurve;
import weka.core.Instances;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class WekaCostCurve
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected ThresholdVisualizePanel m_VisualizePanel;
    protected Index m_ClassLabelIndex;

    public String globalInfo() {
        return "Actor for displaying classifier errors.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "classLabelIndex", (Object)new Index("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassLabelIndex = new Index("first");
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void setClassLabelIndex(Index value) {
        this.m_ClassLabelIndex = value;
        this.reset();
    }

    public Index getClassLabelIndex() {
        return this.m_ClassLabelIndex;
    }

    public String classLabelIndexTipText() {
        return "The index of the class label to use for the plot.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classLabelIndex", (Object)this.m_ClassLabelIndex, (String)", class label: ");
        return result;
    }

    public void clearPanel() {
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_VisualizePanel = new ThresholdVisualizePanel();
        result.add((Component)this.m_VisualizePanel, (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected void display(Token token) {
        try {
            Evaluation eval = token.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation") : (Evaluation)token.getPayload();
            if (eval.predictions() == null) {
                this.getLogger().severe("No predictions available from Evaluation object!");
                return;
            }
            this.m_ClassLabelIndex.setMax(eval.getHeader().classAttribute().numValues());
            CostCurve cc = new CostCurve();
            Instances cost = cc.getCurve(eval.predictions(), this.m_ClassLabelIndex.getIntIndex());
            PlotData2D plot = new PlotData2D(cost);
            plot.m_displayAllPoints = true;
            boolean[] connectPoints = new boolean[cost.numInstances()];
            for (int jj = 1; jj < connectPoints.length; jj += 2) {
                connectPoints[jj] = true;
            }
            plot.setConnectPoints(connectPoints);
            this.m_VisualizePanel.addPlot(plot);
        }
        catch (Exception e) {
            this.handleException("Failed to display token: " + token, e);
        }
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
            this.m_VisualizePanel = null;
        }
    }

    protected Evaluation getEvaluation(Token token) {
        if (token.getPayload() instanceof WekaEvaluationContainer) {
            return (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation");
        }
        return (Evaluation)token.getPayload();
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        String name = "Cost curve (" + this.getEvaluation(token).getHeader().relationName() + ")";
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(name){
            private static final long serialVersionUID = -3513994354297811163L;
            protected VisualizePanel m_VisualizePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_VisualizePanel = new VisualizePanel();
                this.add((Component)this.m_VisualizePanel, "Center");
            }

            public void display(Token token) {
                try {
                    Evaluation eval = WekaCostCurve.this.getEvaluation(token);
                    WekaCostCurve.this.m_ClassLabelIndex.setMax(eval.getHeader().classAttribute().numValues());
                    CostCurve cc = new CostCurve();
                    Instances cost = cc.getCurve(eval.predictions(), WekaCostCurve.this.m_ClassLabelIndex.getIntIndex());
                    PlotData2D plot = new PlotData2D(cost);
                    plot.m_displayAllPoints = true;
                    boolean[] connectPoints = new boolean[cost.numInstances()];
                    for (int jj = 1; jj < connectPoints.length; jj += 2) {
                        connectPoints[jj] = true;
                    }
                    plot.setConnectPoints(connectPoints);
                    this.m_VisualizePanel.addPlot(plot);
                }
                catch (Exception e) {
                    WekaCostCurve.this.getLogger().log(Level.SEVERE, "Failed to display token: " + token, e);
                }
            }

            public JComponent supplyComponent() {
                return this.m_VisualizePanel;
            }

            public void clearPanel() {
                this.m_VisualizePanel.removeAllPlots();
            }

            public void cleanUp() {
                this.m_VisualizePanel.removeAllPlots();
            }
        };
        result.display(token);
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }
}

