/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractWekaPredictionsTransformer;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.FastVector;
import weka.core.Instances;

public class WekaPredictionsToSpreadSheet
extends AbstractWekaPredictionsTransformer {
    private static final long serialVersionUID = -1552754008462778501L;

    public String globalInfo() {
        return "Generates a SpreadSheet object from the predictions of an Evaluation object.";
    }

    protected String doExecute() {
        String result = null;
        Evaluation eval = this.m_InputToken.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation") : (Evaluation)this.m_InputToken.getPayload();
        Instances header = eval.getHeader();
        boolean nominal = header.classAttribute().isNominal();
        FastVector predictions = eval.predictions();
        if (predictions != null) {
            int n;
            SpreadSheet data = new SpreadSheet();
            data.setName("Predictions");
            HeaderRow row = data.getHeaderRow();
            row.addCell("A").setContent("Actual");
            row.addCell("P").setContent("Predicted");
            int indexErr = -1;
            if (this.m_ShowError) {
                indexErr = row.getCellCount();
                row.addCell("E").setContent("Error");
            }
            int indexProb = -1;
            if (this.m_ShowProbability && nominal) {
                indexProb = row.getCellCount();
                row.addCell("Pr").setContent("Probability");
            }
            int indexDist = -1;
            if (this.m_ShowDistribution && nominal) {
                indexDist = row.getCellCount();
                for (n = 0; n < header.classAttribute().numValues(); ++n) {
                    row.addCell("D" + n).setContent("Distribution (" + header.classAttribute().value(n) + ")");
                }
            }
            int indexWeight = -1;
            if (this.m_ShowWeight) {
                indexWeight = row.getCellCount();
                row.addCell("W").setContent("Weight");
            }
            for (int i = 0; i < predictions.size(); ++i) {
                Prediction pred = (Prediction)predictions.get(i);
                row = data.addRow();
                row.addCell(0).setContent(Double.valueOf(pred.actual()));
                row.addCell(1).setContent(Double.valueOf(pred.predicted()));
                if (this.m_ShowError) {
                    if (nominal) {
                        row.addCell(indexErr).setContent(pred.actual() != pred.predicted() ? "y" : "n");
                    } else {
                        row.addCell(indexErr).setContent(Double.valueOf(Math.abs(pred.actual() - pred.predicted())));
                    }
                }
                if (this.m_ShowProbability && nominal) {
                    row.addCell(indexProb).setContent(Double.valueOf(StatUtils.max((double[])((NominalPrediction)pred).distribution())));
                }
                if (this.m_ShowDistribution && nominal) {
                    for (n = 0; n < header.classAttribute().numValues(); ++n) {
                        row.addCell(indexDist + n).setContent(Double.valueOf(((NominalPrediction)pred).distribution()[n]));
                    }
                }
                if (!this.m_ShowWeight) continue;
                row.addCell(indexWeight).setContent(Double.valueOf(pred.weight()));
            }
            this.m_OutputToken = new Token((Object)data);
        } else {
            this.getLogger().severe("No predictions available from Evaluation object!");
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }
}

