/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.plugins.ErrorVisualizePlugin;

public class ClassRangeBasedClassifierErrors
implements ErrorVisualizePlugin {
    public static final int REFERENCE_SIZE = 20;

    public JMenuItem getVisualizeMenuItem(final Instances predInst) {
        if (!predInst.classAttribute().isNumeric()) {
            return null;
        }
        JMenuItem result = new JMenuItem("Classifier errors (class range)");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizePanel vp = new VisualizePanel();
                vp.setName("Absolute classifier errors for " + predInst.relationName());
                PlotData2D tempd = new PlotData2D(predInst);
                FastVector plotSize = new FastVector();
                FastVector plotShape = new FastVector();
                double minClass = Double.MAX_VALUE;
                double maxClass = Double.MIN_VALUE;
                for (int i = 0; i < predInst.numInstances(); ++i) {
                    double actual = predInst.instance(i).value(predInst.classIndex());
                    if (minClass > actual) {
                        minClass = actual;
                    }
                    if (!(maxClass < actual)) continue;
                    maxClass = actual;
                }
                double refClass = (maxClass - minClass) / 2.0 + minClass;
                for (int i = 0; i < predInst.numInstances(); ++i) {
                    double actual = predInst.instance(i).value(predInst.classIndex());
                    double predicted = predInst.instance(i).value(predInst.classIndex() - 1);
                    if (Utils.isMissingValue((double)actual) || Utils.isMissingValue((double)predicted)) {
                        plotShape.addElement((Object)new Integer(2000));
                        plotSize.addElement((Object)new Integer(1));
                        continue;
                    }
                    int size = (int)(Math.abs(actual - predicted) / refClass * 20.0);
                    plotShape.addElement((Object)new Integer(-1));
                    plotSize.addElement((Object)new Integer(size));
                }
                try {
                    tempd.setShapeSize(plotSize);
                    tempd.setShapeType(plotShape);
                    tempd.setPlotName("Class-range based classifier errors for " + predInst.relationName());
                    tempd.addInstanceNumberAttribute();
                    vp.addPlot(tempd);
                    vp.setColourIndex(predInst.classIndex() + 1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                try {
                    vp.setXIndex(vp.getInstances().classIndex());
                    vp.setYIndex(vp.getInstances().classIndex() - 1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                final JFrame jf = new JFrame("Class-range based classifier errors for " + predInst.relationName());
                jf.setSize(800, 600);
                jf.getContentPane().setLayout(new BorderLayout());
                jf.getContentPane().add((Component)vp, "Center");
                jf.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        jf.dispose();
                    }
                });
                jf.setVisible(true);
            }
        });
        return result;
    }

    public String getMinVersion() {
        return "3.5.9";
    }

    public String getMaxVersion() {
        return "3.8.0";
    }

    public String getDesignVersion() {
        return "3.7.9";
    }
}

