/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.scripting.FileBasedScriptingWithOptions;
import adams.data.image.AbstractImage;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;

public abstract class AbstractScriptedTransformer
extends AbstractJAITransformer
implements FileBasedScriptingWithOptions {
    private static final long serialVersionUID = -8187233244973711251L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", (Object)"");
    }

    public void reset() {
        super.reset();
        this.m_ScriptObject = null;
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
        this.reset();
    }

    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    protected void checkImage(BufferedImageContainer img) {
        super.checkImage((AbstractImage)img);
        String msg = this.initScriptObject();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    public void destroy() {
        super.destroy();
        this.m_ScriptObject = null;
    }
}

