/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.ImageMagickHelper;
import adams.core.base.BaseText;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.transformer.ImageMagickTransformer;
import adams.gui.core.TextEditorPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageFilter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class ImageMagick
extends AbstractImageFilter {
    private static final long serialVersionUID = 3840263834155992337L;

    public String getCaption() {
        return "ImageMagick...";
    }

    public boolean canExecute(ImagePanel panel) {
        return ImageMagickHelper.isConvertAvailable() && super.canExecute(panel);
    }

    protected BufferedImage filter(BufferedImage image) {
        BufferedImage result = null;
        ApprovalDialog dialog = this.m_CurrentPanel.getParentDialog() != null ? ApprovalDialog.getDialog((Dialog)this.m_CurrentPanel.getParentDialog()) : ApprovalDialog.getDialog((Frame)this.m_CurrentPanel.getParentFrame());
        TextEditorPanel editor = new TextEditorPanel();
        if (this.hasLastSetup()) {
            editor.setContent((String)this.getLastSetup());
        } else {
            editor.setContent("");
        }
        dialog.setTitle("ImageMagick");
        dialog.getContentPane().add((Component)editor, "Center");
        dialog.getContentPane().add((Component)new JLabel("Please enter the commands"), "North");
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setSize(400, 300);
        dialog.setLocationRelativeTo((Component)this.m_CurrentPanel);
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            this.m_CanceledByUser = true;
            return result;
        }
        this.setLastSetup(editor.getContent());
        ImageMagickTransformer transformer = new ImageMagickTransformer();
        transformer.setCommands(new BaseText(editor.getContent()));
        this.m_FilterError = transformer.setUp();
        if (this.m_FilterError == null) {
            BufferedImageContainer input = new BufferedImageContainer();
            input.setImage((Object)image);
            transformer.input(new Token((Object)input));
            this.m_FilterError = transformer.execute();
            if (this.m_FilterError == null && transformer.hasPendingOutput()) {
                result = (BufferedImage)((BufferedImageContainer)transformer.output().getPayload()).getImage();
            }
            transformer.wrapUp();
            transformer.cleanUp();
        }
        return result;
    }
}

