/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeListener;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.GlobalActorUser;
import java.util.HashSet;

public abstract class AbstractCopyGlobalActor
extends AbstractActor
implements GlobalActorUser {
    private static final long serialVersionUID = -7860206690560690212L;
    protected GlobalActorReference m_GlobalName;
    protected AbstractActor m_GlobalActor;
    protected GlobalActorHelper m_Helper;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("global", "globalName", (Object)new GlobalActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new GlobalActorHelper();
    }

    public void setGlobalName(GlobalActorReference value) {
        this.m_GlobalName = value;
        this.reset();
    }

    public GlobalActorReference getGlobalName() {
        return this.m_GlobalName;
    }

    public String globalNameTipText() {
        return "The name of the global actor to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"globalName", (Object)this.m_GlobalName);
    }

    protected AbstractActor findGlobalActor() {
        return this.m_Helper.findGlobalActorRecursive((AbstractActor)this, this.getGlobalName());
    }

    public boolean hasGlobalActor() {
        return this.m_GlobalActor != null;
    }

    public AbstractActor getGlobalActor() {
        return this.m_GlobalActor;
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        if (this.m_GlobalActor != null) {
            this.m_GlobalActor.setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_GlobalActor = this.findGlobalActor();
            if (this.m_GlobalActor == null) {
                result = "Couldn't find global actor '" + this.getGlobalName() + "'!";
            } else {
                this.m_GlobalActor = this.m_GlobalActor.shallowCopy();
                this.m_GlobalActor.setParent(this.getParent());
                this.m_GlobalActor.setVariables(this.getVariables());
                result = this.m_GlobalActor.setUp();
                if (result == null) {
                    HashSet variables = this.findVariables(this.m_GlobalActor);
                    this.m_DetectedVariables.addAll(variables);
                    if (this.m_DetectedVariables.size() > 0) {
                        this.getVariables().addVariableChangeListener((VariableChangeListener)this);
                    }
                }
            }
        }
        return result;
    }

    protected abstract String executeGlobalActor();

    protected String doExecute() {
        String result = null;
        if (!this.m_GlobalActor.getSkip() && !this.m_GlobalActor.isStopped()) {
            result = this.executeGlobalActor();
        }
        return result;
    }

    public boolean isFinished() {
        if (this.m_GlobalActor == null) {
            return true;
        }
        return this.m_GlobalActor.isFinished();
    }

    public void stopExecution() {
        if (this.m_GlobalActor != null) {
            this.m_GlobalActor.stopExecution();
        }
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_GlobalActor != null) {
            this.m_GlobalActor.wrapUp();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        super.cleanUp();
        if (this.m_GlobalActor != null) {
            this.m_GlobalActor.cleanUp();
            this.m_GlobalActor = null;
        }
    }
}

