/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractCopyGlobalActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class CopyGlobalTransformer
extends AbstractCopyGlobalActor
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = -4898610818562897692L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    public String globalInfo() {
        return "Feeds tokens into the copy of a global transformer and broadcasts the generated output tokens.";
    }

    @Override
    protected AbstractActor findGlobalActor() {
        AbstractActor result = super.findGlobalActor();
        if (result != null && !ActorUtils.isTransformer((AbstractActor)result)) {
            this.getLogger().severe("Global actor '" + result.getFullName() + "' is not a transformer!");
            result = null;
        }
        return result;
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_INPUT, this.m_InputToken);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_InputToken = null;
    }

    public Class[] accepts() {
        if (this.m_GlobalActor != null) {
            return ((InputConsumer)this.m_GlobalActor).accepts();
        }
        return new Class[]{Unknown.class};
    }

    public void input(Token token) {
        this.m_InputToken = token;
    }

    public Class[] generates() {
        if (this.m_GlobalActor != null) {
            return ((OutputProducer)this.m_GlobalActor).generates();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String executeGlobalActor() {
        if (this.m_InputToken != null) {
            ((InputConsumer)this.m_GlobalActor).input(this.m_InputToken);
        }
        String result = this.m_GlobalActor.execute();
        return result;
    }

    public Token output() {
        this.m_InputToken = null;
        return ((OutputProducer)this.m_GlobalActor).output();
    }

    public boolean hasPendingOutput() {
        return ((OutputProducer)this.m_GlobalActor).hasPendingOutput();
    }
}

