/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import moa.evaluation.Accuracy;
import moa.evaluation.MeasureCollection;
import moa.gui.FileExtensionFilter;
import moa.gui.GUIUtils;
import moa.gui.clustertab.ClusteringVisualEvalPanel;
import moa.gui.visualization.GraphCanvas;
import moa.gui.visualization.StreamPanel;

public class TaskTextViewerPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static String exportFileExtension = "txt";
    protected JTextArea textArea;
    protected JScrollPane scrollPane;
    protected JButton exportButton;
    private JPanel topWrapper;
    private JSplitPane jSplitPane1;
    protected MeasureCollection[] acc1 = new MeasureCollection[1];
    protected MeasureCollection[] acc2 = new MeasureCollection[1];
    protected String secondLine = "";
    private JButton buttonRun;
    private JButton buttonScreenshot;
    private JButton buttonStop;
    private JButton buttonZoomInX;
    private JButton buttonZoomInY;
    private JButton buttonZoomOutX;
    private JButton buttonZoomOutY;
    private JCheckBox checkboxDrawClustering;
    private JCheckBox checkboxDrawGT;
    private JCheckBox checkboxDrawMicro;
    private JCheckBox checkboxDrawPoints;
    private ClusteringVisualEvalPanel clusteringVisualEvalPanel1;
    private JComboBox comboX;
    private JComboBox comboY;
    private GraphCanvas graphCanvas;
    private JPanel graphPanel;
    private JPanel graphPanelControlBottom;
    private JPanel graphPanelControlTop;
    private JScrollPane graphScrollPanel;
    private JLabel jLabel1;
    private JLabel labelEvents;
    private JLabel labelNumPause;
    private JLabel labelX;
    private JLabel labelY;
    private JLabel label_processed_points;
    private JLabel label_processed_points_value;
    private JTextField numPauseAfterPoints;
    private JPanel panelControl;
    private JPanel panelEvalOutput;
    private JPanel panelVisualWrapper;
    private JScrollPane scrollPane0;
    private JScrollPane scrollPane1;
    private JSlider speedSlider;
    private JSplitPane splitVisual;
    private StreamPanel streamPanel0;
    private StreamPanel streamPanel1;

    public TaskTextViewerPanel() {
        this.jSplitPane1 = new JSplitPane();
        this.topWrapper = new JPanel();
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.exportButton = new JButton("Export as .txt file...");
        this.exportButton.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.exportButton);
        this.topWrapper.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.textArea);
        this.topWrapper.add((Component)this.scrollPane, "Center");
        this.topWrapper.add((Component)buttonPanel, "South");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.addChoosableFileFilter(new FileExtensionFilter(exportFileExtension));
                if (fileChooser.showSaveDialog(TaskTextViewerPanel.this) == 0) {
                    File chosenFile = fileChooser.getSelectedFile();
                    String fileName = chosenFile.getPath();
                    if (!chosenFile.exists() && !fileName.endsWith(exportFileExtension)) {
                        fileName = fileName + "." + exportFileExtension;
                    }
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        out.write(TaskTextViewerPanel.this.textArea.getText());
                        out.close();
                    }
                    catch (IOException ioe) {
                        GUIUtils.showExceptionDialog(TaskTextViewerPanel.this.exportButton, "Problem saving file " + fileName, ioe);
                    }
                }
            }
        });
        this.panelEvalOutput = new JPanel();
        this.clusteringVisualEvalPanel1 = new ClusteringVisualEvalPanel();
        this.graphPanel = new JPanel();
        this.graphPanelControlTop = new JPanel();
        this.buttonZoomInY = new JButton();
        this.buttonZoomOutY = new JButton();
        this.labelEvents = new JLabel();
        this.graphScrollPanel = new JScrollPane();
        this.graphCanvas = new GraphCanvas();
        this.graphPanelControlBottom = new JPanel();
        this.buttonZoomInX = new JButton();
        this.buttonZoomOutX = new JButton();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLeftComponent(this.topWrapper);
        this.panelEvalOutput.setBorder(BorderFactory.createTitledBorder("Evaluation"));
        this.panelEvalOutput.setLayout(new GridBagLayout());
        this.clusteringVisualEvalPanel1.setMinimumSize(new Dimension(280, 118));
        this.clusteringVisualEvalPanel1.setPreferredSize(new Dimension(290, 115));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.panelEvalOutput.add((Component)this.clusteringVisualEvalPanel1, gridBagConstraints);
        this.graphPanel.setBorder(BorderFactory.createTitledBorder("Plot"));
        this.graphPanel.setPreferredSize(new Dimension(530, 115));
        this.graphPanel.setLayout(new GridBagLayout());
        this.graphPanelControlTop.setLayout(new GridBagLayout());
        this.buttonZoomInY.setText("Zoom in Y");
        this.buttonZoomInY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskTextViewerPanel.this.buttonZoomInYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.buttonZoomInY, gridBagConstraints);
        this.buttonZoomOutY.setText("Zoom out Y");
        this.buttonZoomOutY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskTextViewerPanel.this.buttonZoomOutYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.buttonZoomOutY, gridBagConstraints);
        this.labelEvents.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.labelEvents, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.graphPanel.add((Component)this.graphPanelControlTop, gridBagConstraints);
        this.graphCanvas.setPreferredSize(new Dimension(500, 111));
        GroupLayout graphCanvasLayout = new GroupLayout(this.graphCanvas);
        this.graphCanvas.setLayout(graphCanvasLayout);
        graphCanvasLayout.setHorizontalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        graphCanvasLayout.setVerticalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        this.graphScrollPanel.setViewportView(this.graphCanvas);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.graphPanel.add((Component)this.graphScrollPanel, gridBagConstraints);
        this.buttonZoomInX.setText("Zoom in X");
        this.buttonZoomInX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskTextViewerPanel.this.buttonZoomInXActionPerformed(evt);
            }
        });
        this.graphPanelControlBottom.add(this.buttonZoomInX);
        this.buttonZoomOutX.setText("Zoom out X");
        this.buttonZoomOutX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskTextViewerPanel.this.buttonZoomOutXActionPerformed(evt);
            }
        });
        this.graphPanelControlBottom.add(this.buttonZoomOutX);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.graphPanel.add((Component)this.graphPanelControlBottom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.panelEvalOutput.add((Component)this.graphPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.panelEvalOutput);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.acc1[0] = new Accuracy();
        this.acc2[0] = new Accuracy();
        this.clusteringVisualEvalPanel1.setMeasures(this.acc1, this.acc2, this);
        this.graphCanvas.setGraph(this.acc1[0], this.acc2[0], 0, 1000);
    }

    public void setText(String newText) {
        Point p = this.scrollPane.getViewport().getViewPosition();
        this.textArea.setText(newText);
        this.scrollPane.getViewport().setViewPosition(p);
        this.exportButton.setEnabled(newText != null);
        this.setGraph(newText);
    }

    protected double round(double d) {
        return Math.abs(Math.rint(d * 100.0) / 100.0);
    }

    public void setGraph(String preview) {
        double processFrequency = 1000.0;
        if (preview != null && !preview.equals("")) {
            MeasureCollection oldAccuracy = this.acc1[0];
            this.acc1[0] = new Accuracy();
            Scanner scanner = new Scanner(preview);
            String firstLine = scanner.nextLine();
            boolean isSecondLine = true;
            boolean isPrequential = firstLine.startsWith("learning evaluation instances,evaluation time");
            boolean isHoldOut = firstLine.startsWith("evaluation instances,to");
            if (isPrequential || isHoldOut) {
                int accuracyColumn = 4;
                int kappaColumn = 5;
                int RamColumn = 2;
                int timeColumn = 1;
                int memoryColumn = 7;
                String[] tokensFirstLine = firstLine.split(",");
                int i = 0;
                for (String s : tokensFirstLine) {
                    if (s.equals("classifications correct (percent)")) {
                        accuracyColumn = i;
                    } else if (s.equals("Kappa Statistic (percent)")) {
                        kappaColumn = i;
                    } else if (s.equals("model cost (RAM-Hours)")) {
                        RamColumn = i;
                    } else if (s.equals("evaluation time (cpu seconds)") || s.equals("total train time")) {
                        timeColumn = i;
                    } else if (s.equals("model serialized size (bytes)")) {
                        memoryColumn = i;
                    }
                    ++i;
                }
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] tokens = line.split(",");
                    this.acc1[0].addValue(0, this.round(Double.parseDouble(tokens[accuracyColumn])));
                    this.acc1[0].addValue(1, this.round(Double.parseDouble(tokens[kappaColumn])));
                    if (!isHoldOut) {
                        this.acc1[0].addValue(2, Math.abs(Double.parseDouble(tokens[RamColumn])));
                    }
                    this.acc1[0].addValue(3, this.round(Double.parseDouble(tokens[timeColumn])));
                    this.acc1[0].addValue(4, this.round(Double.parseDouble(tokens[memoryColumn]) / 1048576.0));
                    if (!isSecondLine) continue;
                    processFrequency = Math.abs(Double.parseDouble(tokens[0]));
                    isSecondLine = false;
                    if (this.acc1[0].getValue(0, 0) == oldAccuracy.getValue(0, 0)) continue;
                    this.secondLine = line;
                    if (processFrequency != (double)this.graphCanvas.getProcessFrequency()) continue;
                    this.acc2[0] = oldAccuracy;
                }
            } else {
                this.acc2[0] = new Accuracy();
            }
        } else {
            this.acc1[0] = new Accuracy();
            this.acc2[0] = new Accuracy();
        }
        this.graphCanvas.setGraph(this.acc1[0], this.acc2[0], this.graphCanvas.getMeasureSelected(), (int)processFrequency);
        this.graphCanvas.updateCanvas();
        this.clusteringVisualEvalPanel1.update();
    }

    private void scrollPane0MouseWheelMoved(MouseWheelEvent evt) {
        this.streamPanel0.setZoom(evt.getX(), evt.getY(), -1 * evt.getWheelRotation(), this.scrollPane0);
    }

    private void buttonZoomInXActionPerformed(ActionEvent evt) {
        this.graphCanvas.scaleXResolution(false);
    }

    private void buttonZoomOutYActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 0.8)));
        this.graphCanvas.setPreferredSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 0.8)));
        this.graphCanvas.updateCanvas(true);
    }

    private void buttonZoomOutXActionPerformed(ActionEvent evt) {
        this.graphCanvas.scaleXResolution(true);
    }

    private void buttonZoomInYActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 1.2)));
        this.graphCanvas.setPreferredSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 1.2)));
        this.graphCanvas.updateCanvas(true);
    }

    private void buttonRunActionPerformed(ActionEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selected;
        int counter = selected = Integer.parseInt(e.getActionCommand());
        int m_select = 0;
        int m_select_offset = 0;
        boolean found = false;
        for (int i = 0; i < this.acc1.length; ++i) {
            for (int j = 0; j < this.acc1[i].getNumMeasures(); ++j) {
                if (!this.acc1[i].isEnabled(j) || --counter >= 0) continue;
                m_select = i;
                m_select_offset = j;
                found = true;
                break;
            }
            if (found) break;
        }
        this.graphCanvas.setGraph(this.acc1[m_select], this.acc2[m_select], m_select_offset, this.graphCanvas.getProcessFrequency());
    }
}

