/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import moa.gui.visualization.ClusterPanel;
import moa.gui.visualization.DataPoint;
import moa.gui.visualization.RunVisualizer;
import moa.gui.visualization.StreamPanel;

public class PointPanel
extends JPanel {
    static final int POINTSIZE = 4;
    DataPoint point;
    protected int x_dim = 0;
    protected int y_dim = 1;
    protected Color col;
    protected Color default_color = Color.BLACK;
    protected int panel_size;
    protected int window_size;
    protected boolean highligted = false;
    protected double decayRate;
    protected double decayThreshold;

    public PointPanel(DataPoint point, double decayRate, double decayThreshold) {
        this.point = point;
        this.col = Color.BLACK;
        this.panel_size = 4;
        this.decayRate = decayRate;
        this.decayThreshold = decayThreshold;
        this.col = this.default_color;
        this.setVisible(true);
        this.setOpaque(false);
        this.setSize(new Dimension(1, 1));
        this.setLocation(0, 0);
        this.initComponents();
    }

    public void updateLocation() {
        this.window_size = Math.min(this.getParent().getWidth(), this.getParent().getHeight());
        StreamPanel sp = (StreamPanel)this.getParent().getParent();
        this.x_dim = sp.getActiveXDim();
        this.y_dim = sp.getActiveYDim();
        this.setSize(new Dimension(this.panel_size + 1, this.panel_size + 1));
        this.setLocation((int)(this.point.value(this.x_dim) * (double)this.window_size - (double)(this.panel_size / 2)), (int)(this.point.value(this.y_dim) * (double)this.window_size - (double)(this.panel_size / 2)));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 266, Short.MAX_VALUE));
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.point.updateWeight(RunVisualizer.getCurrentTimestamp(), this.decayRate);
        if (this.point.weight() < this.decayThreshold) {
            this.getParent().remove(this);
            return;
        }
        Color color = this.getColor();
        Color errcolor = this.getErrorColor();
        if (errcolor == null) {
            errcolor = color;
            this.panel_size = 4;
        } else {
            this.panel_size = 6;
        }
        this.updateLocation();
        g.setColor(errcolor);
        g.drawOval(0, 0, this.panel_size, this.panel_size);
        g.setColor(color);
        g.fillOval(0, 0, this.panel_size, this.panel_size);
        this.setToolTipText(this.point.getInfo(this.x_dim, this.y_dim));
    }

    private Color getErrorColor() {
        String cmdvalue = this.point.getMeasureValue("CMM");
        Color color = null;
        if (!cmdvalue.equals("")) {
            double err = Double.parseDouble(cmdvalue);
            if (err > 1.0E-5) {
                if (err > 0.7) {
                    err = 1.0;
                }
                int alpha = (int)(100.0 + 155.0 * err);
                color = new Color(255, 0, 0, alpha);
            }
            if (err == 1.0E-5) {
                color = new Color(255, 0, 0, 100);
            }
        }
        return color;
    }

    private Color getColor() {
        StreamPanel sp;
        ClusterPanel cp;
        Color color = null;
        if (this.getParent() instanceof StreamPanel && (cp = (sp = (StreamPanel)this.getParent()).getHighlightedClusterPanel()) != null && (double)cp.getClusterLabel() == this.point.classValue()) {
            color = Color.BLUE;
        }
        if (color == null) {
            int alpha = (int)(this.point.weight() * 200.0 + 55.0);
            float numCl = 10.0f;
            Color c = PointPanel.getPointColorbyClass((int)this.point.classValue(), numCl);
            color = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return color;
    }

    public static Color getPointColorbyClass(int classValue, float numClasses) {
        Color c = classValue != -1 ? new Color(Color.HSBtoRGB((float)(classValue + 1) / numClasses, 1.0f, 1.0f)) : Color.GRAY;
        return c;
    }

    public void highlight(boolean enabled) {
        this.highligted = enabled;
        this.repaint();
    }

    public String getObjectInfo() {
        return this.point.getInfo(this.x_dim, this.y_dim);
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    public String getSVGString(int width) {
        StringBuffer out = new StringBuffer();
        int x = (int)(this.point.value(this.x_dim) * (double)this.window_size);
        int y = (int)(this.point.value(this.y_dim) * (double)this.window_size);
        int radius = this.panel_size / 2;
        Color c = this.getColor();
        String color = "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
        double trans = (double)c.getAlpha() / 255.0;
        out.append("<circle ");
        out.append("cx='" + x + "' cy='" + y + "' r='" + radius + "'");
        out.append(" stroke='" + color + "' stroke-width='0' fill='" + color + "' fill-opacity='" + trans + "' stroke-opacity='" + trans + "'/>");
        out.append("\n");
        return out.toString();
    }
}

