/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval;

import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.core.Utils;

public class MSEModule
extends ErrorModule {
    @Override
    public String getEvalName() {
        return "MSE";
    }

    @Override
    public String getDescription() {
        return "Mean squared error";
    }

    @Override
    public String getDefinition() {
        return "sum((predicted - actual)^2) / N";
    }

    @Override
    public double[] calculateMeasure() throws Exception {
        int i;
        double[] result = new double[this.m_targetFieldNames.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = Utils.missingValue();
        }
        for (i = 0; i < this.m_targetFieldNames.size(); ++i) {
            double sumSq = 0.0;
            List preds = (List)this.m_predictions.get(i);
            int count = 0;
            for (NumericPrediction p : preds) {
                if (Utils.isMissingValue((double)p.error())) continue;
                sumSq += p.error() * p.error();
                ++count;
            }
            if (this.m_counts[i] > 0.0) {
                sumSq /= this.m_counts[i];
            }
            result[i] = count > 0 ? sumSq : Utils.missingValue();
        }
        return result;
    }
}

