/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.DirectMessage;
import twitter4j.RawStreamListener;
import twitter4j.Status;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.z_T4JInternalFactory;
import twitter4j.internal.json.z_T4JInternalJSONImplFactory;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.json.JSONObjectType;

abstract class StatusStreamBase
implements StatusStream {
    protected static final Logger logger = Logger.getLogger(StatusStreamImpl.class);
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;
    protected final Dispatcher dispatcher;
    protected final Configuration CONF;
    protected z_T4JInternalFactory factory;

    StatusStreamBase(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        this.dispatcher = dispatcher;
        this.CONF = conf;
        this.factory = new z_T4JInternalJSONImplFactory(conf);
    }

    StatusStreamBase(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        this(dispatcher, response.asStream(), conf);
        this.response = response;
    }

    protected String parseLine(String line) {
        return line;
    }

    protected void handleNextElement(final StreamListener[] listeners, final RawStreamListener[] rawStreamListeners) throws TwitterException {
        block6: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.br.readLine();
                if (null == line) {
                    throw new IOException("the end of the stream has been reached");
                }
                this.dispatcher.invokeLater((Runnable)new StreamEvent(line){

                    public void run() {
                        try {
                            if (rawStreamListeners.length > 0) {
                                StatusStreamBase.this.onMessage(this.line, rawStreamListeners);
                            }
                            this.line = StatusStreamBase.this.parseLine(this.line);
                            if (this.line != null && this.line.length() > 0 && listeners.length > 0) {
                                if (StatusStreamBase.this.CONF.isJSONStoreEnabled()) {
                                    DataObjectFactoryUtil.clearThreadLocalMap();
                                }
                                JSONObject json = new JSONObject(this.line);
                                JSONObjectType.Type event = JSONObjectType.determine((JSONObject)json);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Received:", StatusStreamBase.this.CONF.isPrettyDebugEnabled() ? json.toString(1) : json.toString());
                                }
                                switch (event) {
                                    case SENDER: {
                                        StatusStreamBase.this.onSender(json, listeners);
                                        break;
                                    }
                                    case STATUS: {
                                        StatusStreamBase.this.onStatus(json, listeners);
                                        break;
                                    }
                                    case DIRECT_MESSAGE: {
                                        StatusStreamBase.this.onDirectMessage(json, listeners);
                                        break;
                                    }
                                    case DELETE: {
                                        StatusStreamBase.this.onDelete(json, listeners);
                                        break;
                                    }
                                    case LIMIT: {
                                        StatusStreamBase.this.onLimit(json, listeners);
                                        break;
                                    }
                                    case STALL_WARNING: {
                                        StatusStreamBase.this.onStallWarning(json, listeners);
                                        break;
                                    }
                                    case SCRUB_GEO: {
                                        StatusStreamBase.this.onScrubGeo(json, listeners);
                                        break;
                                    }
                                    case FRIENDS: {
                                        StatusStreamBase.this.onFriends(json, listeners);
                                        break;
                                    }
                                    case FAVORITE: {
                                        StatusStreamBase.this.onFavorite(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case UNFAVORITE: {
                                        StatusStreamBase.this.onUnfavorite(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case FOLLOW: {
                                        StatusStreamBase.this.onFollow(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case UNFOLLOW: {
                                        StatusStreamBase.this.onUnfollow(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case USER_LIST_MEMBER_ADDED: {
                                        StatusStreamBase.this.onUserListMemberAddition(json.getJSONObject("target"), json.getJSONObject("source"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_MEMBER_DELETED: {
                                        StatusStreamBase.this.onUserListMemberDeletion(json.getJSONObject("target"), json.getJSONObject("source"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_SUBSCRIBED: {
                                        StatusStreamBase.this.onUserListSubscription(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_UNSUBSCRIBED: {
                                        StatusStreamBase.this.onUserListUnsubscription(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_CREATED: {
                                        StatusStreamBase.this.onUserListCreation(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case USER_LIST_UPDATED: {
                                        StatusStreamBase.this.onUserListUpdated(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case USER_LIST_DESTROYED: {
                                        StatusStreamBase.this.onUserListDestroyed(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case USER_UPDATE: {
                                        StatusStreamBase.this.onUserUpdate(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case BLOCK: {
                                        StatusStreamBase.this.onBlock(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case UNBLOCK: {
                                        StatusStreamBase.this.onUnblock(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case DISCONNECTION: {
                                        StatusStreamBase.this.onDisconnectionNotice(this.line, listeners);
                                        break;
                                    }
                                    default: {
                                        logger.warn("Received unknown event:", StatusStreamBase.this.CONF.isPrettyDebugEnabled() ? json.toString(1) : json.toString());
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            StatusStreamBase.this.onException(ex, listeners);
                        }
                    }
                });
            }
            catch (IOException ioe) {
                try {
                    this.is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                boolean isUnexpectedException = this.streamAlive;
                this.streamAlive = false;
                if (!isUnexpectedException) break block6;
                throw new TwitterException("Stream closed.", (Throwable)ioe);
            }
        }
    }

    protected void onMessage(String rawString, RawStreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onMessage");
    }

    protected void onSender(JSONObject json, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onSender");
    }

    protected void onStatus(JSONObject json, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onStatus");
    }

    protected void onDirectMessage(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onDirectMessage");
    }

    protected void onDelete(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onDelete");
    }

    protected void onLimit(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onLimit");
    }

    protected void onStallWarning(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onStallWarning");
    }

    protected void onScrubGeo(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onScrubGeo");
    }

    protected void onFriends(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onFriends");
    }

    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onFavorite");
    }

    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUnfavorite");
    }

    protected void onFollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onFollow");
    }

    protected void onUnfollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUnfollow");
    }

    protected void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListMemberAddition");
    }

    protected void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListMemberDeletion");
    }

    protected void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListSubscription");
    }

    protected void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListUnsubscription");
    }

    protected void onUserListCreation(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListCreation");
    }

    protected void onUserListUpdated(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListUpdated");
    }

    protected void onUserListDestroyed(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUserListDestroyed");
    }

    protected void onUserUpdate(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUserUpdate");
    }

    protected void onBlock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onBlock");
    }

    protected void onUnblock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUnblock");
    }

    protected void onDisconnectionNotice(String line, StreamListener[] listeners) {
        logger.warn("Unhandled event: ", line);
    }

    protected void onException(Exception e, StreamListener[] listeners) {
        logger.warn("Unhandled event: ", e.getMessage());
    }

    public void close() throws IOException {
        this.streamAlive = false;
        this.is.close();
        this.br.close();
        if (this.response != null) {
            this.response.disconnect();
        }
    }

    protected Status asStatus(JSONObject json) throws TwitterException {
        Status status = this.factory.createStatus(json);
        if (this.CONF.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject((Object)status, (Object)json);
        }
        return status;
    }

    protected DirectMessage asDirectMessage(JSONObject json) throws TwitterException {
        DirectMessage directMessage;
        try {
            directMessage = this.factory.createDirectMessage(json.getJSONObject("direct_message"));
        }
        catch (JSONException e) {
            throw new TwitterException((Exception)((Object)e));
        }
        if (this.CONF.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject((Object)directMessage, (Object)json);
        }
        return directMessage;
    }

    protected long[] asFriendList(JSONObject json) throws TwitterException {
        try {
            JSONArray friends = json.getJSONArray("friends");
            long[] friendIds = new long[friends.length()];
            for (int i = 0; i < friendIds.length; ++i) {
                friendIds[i] = Long.parseLong(friends.getString(i));
            }
            return friendIds;
        }
        catch (JSONException e) {
            throw new TwitterException((Exception)((Object)e));
        }
    }

    protected User asUser(JSONObject json) throws TwitterException {
        User user = this.factory.createUser(json);
        if (this.CONF.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject((Object)user, (Object)json);
        }
        return user;
    }

    protected UserList asUserList(JSONObject json) throws TwitterException {
        UserList userList = this.factory.createAUserList(json);
        if (this.CONF.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject((Object)userList, (Object)json);
        }
        return userList;
    }

    public abstract void next(StatusListener var1) throws TwitterException;

    public abstract void next(StreamListener[] var1, RawStreamListener[] var2) throws TwitterException;

    public void onException(Exception e, StreamListener[] listeners, RawStreamListener[] rawStreamListeners) {
        for (StreamListener streamListener : listeners) {
            streamListener.onException(e);
        }
        for (StreamListener streamListener : rawStreamListeners) {
            streamListener.onException(e);
        }
    }

    abstract class StreamEvent
    implements Runnable {
        String line;

        StreamEvent(String line) {
            this.line = line;
        }
    }
}

