/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.write.ImageDataOffsets;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputItem;

class TiffOutputSummary
implements TiffConstants {
    public final int byteOrder;
    public final TiffOutputDirectory rootDirectory;
    public final Map directoryTypeMap;
    private List offsetItems = new ArrayList();
    private List imageDataItems = new ArrayList();

    public TiffOutputSummary(int byteOrder, TiffOutputDirectory rootDirectory, Map directoryTypeMap) {
        this.byteOrder = byteOrder;
        this.rootDirectory = rootDirectory;
        this.directoryTypeMap = directoryTypeMap;
    }

    public void add(TiffOutputItem item, TiffOutputField itemOffsetField) {
        this.offsetItems.add(new OffsetItem(item, itemOffsetField));
    }

    public void updateOffsets(int byteOrder) throws ImageWriteException {
        int i;
        for (i = 0; i < this.offsetItems.size(); ++i) {
            OffsetItem offset = (OffsetItem)this.offsetItems.get(i);
            byte[] value = FIELD_TYPE_LONG.writeData(new int[]{offset.item.getOffset()}, byteOrder);
            offset.itemOffsetField.setData(value);
        }
        for (i = 0; i < this.imageDataItems.size(); ++i) {
            ImageDataOffsets imageDataInfo = (ImageDataOffsets)this.imageDataItems.get(i);
            for (int j = 0; j < imageDataInfo.outputItems.length; ++j) {
                TiffOutputItem item = imageDataInfo.outputItems[j];
                imageDataInfo.imageDataOffsets[j] = item.getOffset();
            }
            imageDataInfo.imageDataOffsetsField.setData(FIELD_TYPE_LONG.writeData(imageDataInfo.imageDataOffsets, byteOrder));
        }
    }

    public void addTiffImageData(ImageDataOffsets imageDataInfo) {
        this.imageDataItems.add(imageDataInfo);
    }

    private static class OffsetItem {
        public final TiffOutputItem item;
        public final TiffOutputField itemOffsetField;

        public OffsetItem(TiffOutputItem item, TiffOutputField itemOffsetField) {
            this.itemOffsetField = itemOffsetField;
            this.item = item;
        }
    }
}

