/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.spreadsheet.AbstractObjectHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.StringObjectHandler;

public class SpreadSheetObjectColumnToString
extends AbstractSpreadSheetColumnConverter {
    private static final long serialVersionUID = 5248973413873945972L;
    protected AbstractObjectHandler m_Handler;

    public String globalInfo() {
        return "Converts the specified spreadsheet column from the object type to string. Ignores cells that have no objects set, by setting them to missing.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new StringObjectHandler());
    }

    @Override
    public String columnTipText() {
        return "The column to convert to string; " + this.m_Column.getExample();
    }

    public void setHandler(AbstractObjectHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractObjectHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler for converting the objects in the cells into their string representations.";
    }

    @Override
    protected void convert(Cell cellOld, Cell cellNew) throws Exception {
        Object obj = cellOld.getObject();
        if (obj != null) {
            cellNew.setContentAsString(this.m_Handler.format(obj));
        } else {
            cellNew.setMissing();
        }
    }
}

