/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.AbstractTextualDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ColorHelper;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SpreadSheetDisplay
extends AbstractTextualDisplay
implements DisplayPanelProvider,
SpreadSheetSupporter {
    private static final long serialVersionUID = 3247255046513744115L;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetTableModel m_TableModel;
    protected SearchPanel m_PanelSearch;
    protected int m_NumDecimals;
    protected boolean m_UseCustomNegativeBackground;
    protected Color m_NegativeBackground;
    protected boolean m_UseCustomPositiveBackground;
    protected Color m_PositiveBackground;
    protected boolean m_ShowFormulas;
    protected boolean m_AllowSearch;
    protected boolean m_OptimalColumnWidth;

    public String globalInfo() {
        return "Actor for displaying a spreadsheet.\nCustom background for negative/positive values can be specified as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)3, (Number)-1, null);
        this.m_OptionManager.add("use-custom-negative-background", "useCustomNegativeBackground", (Object)false);
        this.m_OptionManager.add("negative-background", "negativeBackground", (Object)Color.WHITE);
        this.m_OptionManager.add("use-custom-positive-background", "useCustomPositiveBackground", (Object)false);
        this.m_OptionManager.add("positive-background", "positiveBackground", (Object)Color.WHITE);
        this.m_OptionManager.add("show-formulas", "showFormulas", (Object)false);
        this.m_OptionManager.add("allow-search", "allowSearch", (Object)false);
        this.m_OptionManager.add("optimal-column-width", "optimalColumnWidth", (Object)true);
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numDecimals", (Object)this.m_NumDecimals, (String)", decimals: ");
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useCustomNegativeBackground") || this.m_UseCustomNegativeBackground) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"negativeBackground", (Object)ColorHelper.toHex((Color)this.m_NegativeBackground), (String)", negative: ");
        }
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useCustomPositiveBackground") || this.m_UseCustomPositiveBackground) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"positiveBackground", (Object)ColorHelper.toHex((Color)this.m_PositiveBackground), (String)", positive: ");
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"showFormulas", (boolean)this.m_ShowFormulas, (String)"formulas", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"allowSearch", (boolean)this.m_AllowSearch, (String)"searchable", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"optimalColumnWidth", (boolean)this.m_OptimalColumnWidth, (String)"optimal", (String)", ");
        return result;
    }

    public void setNumDecimals(int value) {
        this.m_NumDecimals = value;
        this.reset();
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values.";
    }

    public void setUseCustomNegativeBackground(boolean value) {
        this.m_UseCustomNegativeBackground = value;
        this.reset();
    }

    public boolean getUseCustomNegativeBackground() {
        return this.m_UseCustomNegativeBackground;
    }

    public String useCustomNegativeBackgroundTipText() {
        return "Whether to use a custom background color for negative values.";
    }

    public void setNegativeBackground(Color value) {
        this.m_NegativeBackground = value;
        this.reset();
    }

    public Color getNegativeBackground() {
        return this.m_NegativeBackground;
    }

    public String negativeBackgroundTipText() {
        return "The custom background for negative values (must be enabled).";
    }

    public void setUseCustomPositiveBackground(boolean value) {
        this.m_UseCustomPositiveBackground = value;
        this.reset();
    }

    public boolean getUseCustomPositiveBackground() {
        return this.m_UseCustomPositiveBackground;
    }

    public String useCustomPositiveBackgroundTipText() {
        return "Whether to use a custom background color for positive values.";
    }

    public void setPositiveBackground(Color value) {
        this.m_PositiveBackground = value;
        this.reset();
    }

    public Color getPositiveBackground() {
        return this.m_PositiveBackground;
    }

    public String positiveBackgroundTipText() {
        return "The custom background for positive values (must be enabled).";
    }

    public void setShowFormulas(boolean value) {
        this.m_ShowFormulas = value;
        this.reset();
    }

    public boolean getShowFormulas() {
        return this.m_ShowFormulas;
    }

    public String showFormulasTipText() {
        return "Whether to show the formulas or the calculated values.";
    }

    public void setAllowSearch(boolean value) {
        this.m_AllowSearch = value;
        this.reset();
    }

    public boolean getAllowSearch() {
        return this.m_AllowSearch;
    }

    public String allowSearchTipText() {
        return "Whether to allow the user to search the table.";
    }

    public void setOptimalColumnWidth(boolean value) {
        this.m_OptimalColumnWidth = value;
        this.reset();
    }

    public boolean getOptimalColumnWidth() {
        return this.m_OptimalColumnWidth;
    }

    public String optimalColumnWidthTipText() {
        return "Whether to calculate the optimal column width whenever a token is displayed (= enabled) or only when flow finishes.";
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void clearPanel() {
        this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
    }

    public BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
        this.m_Table.setUseOptimalColumnWidhts(this.m_OptimalColumnWidth);
        result.add((Component)new BaseScrollPane((Component)this.m_Table), (Object)"Center");
        this.m_PanelSearch = null;
        if (this.m_AllowSearch) {
            this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
            this.m_PanelSearch.addSearchListener(new SearchListener(){

                public void searchInitiated(SearchEvent e) {
                    SpreadSheetDisplay.this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                }
            });
            result.add((Component)this.m_PanelSearch, (Object)"South");
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected void display(Token token) {
        this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)token.getPayload());
        this.m_Table.setModel((TableModel)this.m_TableModel);
        this.m_Table.setNumDecimals(this.m_NumDecimals);
        if (this.m_UseCustomNegativeBackground) {
            this.m_Table.setNegativeBackground(this.m_NegativeBackground);
        } else {
            this.m_Table.setNegativeBackground(null);
        }
        if (this.m_UseCustomPositiveBackground) {
            this.m_Table.setPositiveBackground(this.m_PositiveBackground);
        } else {
            this.m_Table.setPositiveBackground(null);
        }
        this.m_Table.setShowFormulas(this.m_ShowFormulas);
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel("SpreadSheet"){
            private static final long serialVersionUID = 3524967045456783678L;
            protected SpreadSheetTable m_Table;
            protected SpreadSheetTableModel m_TableModel;
            protected SearchPanel m_PanelSearch;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
                this.m_Table = new SpreadSheetTable(this.m_TableModel);
                this.m_Table.setUseOptimalColumnWidhts(SpreadSheetDisplay.this.m_OptimalColumnWidth);
                this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
                this.m_PanelSearch = null;
                if (SpreadSheetDisplay.this.m_AllowSearch) {
                    this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
                    this.m_PanelSearch.addSearchListener(new SearchListener(){

                        public void searchInitiated(SearchEvent e) {
                            m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                        }
                    });
                    this.add((Component)this.m_PanelSearch, "South");
                }
            }

            public void display(Token token) {
                this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)token.getPayload());
                this.m_Table.setModel((TableModel)this.m_TableModel);
                this.m_Table.setNumDecimals(SpreadSheetDisplay.this.m_NumDecimals);
                if (SpreadSheetDisplay.this.m_UseCustomNegativeBackground) {
                    this.m_Table.setNegativeBackground(SpreadSheetDisplay.this.m_NegativeBackground);
                } else {
                    this.m_Table.setNegativeBackground(null);
                }
                if (SpreadSheetDisplay.this.m_UseCustomPositiveBackground) {
                    this.m_Table.setPositiveBackground(SpreadSheetDisplay.this.m_PositiveBackground);
                } else {
                    this.m_Table.setPositiveBackground(null);
                }
                this.m_Table.setShowFormulas(SpreadSheetDisplay.this.m_ShowFormulas);
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return ExtensionFileFilter.getCsvFileFilter();
            }

            public String supplyText() {
                return this.m_TableModel.toSpreadSheet().toString();
            }

            public void clearPanel() {
                this.m_TableModel = new SpreadSheetTableModel();
                this.m_Table.setModel((TableModel)this.m_TableModel);
            }

            public void cleanUp() {
            }
        };
        result.display(token);
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Headless) {
            System.out.println("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n");
            System.out.println(this.m_InputToken.getPayload());
        } else {
            result = super.doExecute();
        }
        return result;
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return ExtensionFileFilter.getCsvFileFilter();
    }

    public String supplyText() {
        String result = null;
        if (this.m_TableModel != null) {
            result = this.m_TableModel.toSpreadSheet().toString();
        }
        return result;
    }

    public Class[] getSendToClasses() {
        ArrayList<Class> result = new ArrayList<Class>(Arrays.asList(super.getSendToClasses()));
        if (!result.contains(JTable.class)) {
            result.add(JTable.class);
        }
        if (!result.contains(SpreadSheetTable.class)) {
            result.add(SpreadSheetTable.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(SpreadSheetTable.class, (Class[])cls)) {
            result = this.m_Table;
            if (this.m_Table.getRowCount() == 0) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this.m_Table;
            if (this.m_Table.getRowCount() == 0) {
                result = null;
            }
        } else {
            result = super.getSendToItem(cls);
        }
        return result;
    }

    public SpreadSheet toSpreadSheet() {
        if (this.m_Table != null) {
            return this.m_Table.toSpreadSheet(TableRowRange.VISIBLE);
        }
        return null;
    }

    public void wrapUp() {
        if (this.m_Table != null && !this.m_OptimalColumnWidth) {
            this.m_Table.setUseOptimalColumnWidhts(true);
        }
        super.wrapUp();
    }
}

