/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class NewSpreadSheet
extends AbstractSimpleSource {
    private static final long serialVersionUID = 494594301273926225L;
    protected String m_Columns;
    protected DataRowType m_DataRowType;

    public String globalInfo() {
        return "Generates an empty spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)"A,B,C");
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)DataRowType.DENSE);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)this.m_Columns, (String)"cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataRowType", (Object)this.m_DataRowType, (String)", row type: ");
        return result;
    }

    public void setColumns(String value) {
        this.m_Columns = value;
        this.reset();
    }

    public String getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The comma-separated list of column names.";
    }

    public void setDataRowType(DataRowType value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRowType getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String[] cols;
        String result = null;
        SpreadSheet sheet = new SpreadSheet();
        sheet.setDataRowClass(this.m_DataRowType.getRowClass());
        for (String col : cols = this.m_Columns.split(",")) {
            sheet.getHeaderRow().addCell("" + sheet.getColumnCount()).setContentAsString(col);
        }
        this.m_OutputToken = new Token((Object)sheet);
        return result;
    }
}

