/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.parser.AbstractSymbolEvaluator;
import adams.parser.spreadsheetquery.Parser;
import adams.parser.spreadsheetquery.Scanner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class SpreadSheetQuery
extends AbstractSymbolEvaluator<SpreadSheet> {
    private static final long serialVersionUID = 8014316012335802585L;
    protected SpreadSheet m_Sheet;
    protected SpreadSheetReader m_Reader;
    protected PlaceholderFile m_Input;

    public String globalInfo() {
        return "Evaluates spreadsheet subset queries.\n\nThe following grammar is used:\n\n" + this.getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
        this.m_OptionManager.add("input", "input", (Object)new PlaceholderFile("."));
    }

    public String getGrammar() {
        return "expr_list ::= expr_list expr_part | expr_part;\n\nexpr_part ::= select | update | delete;\n\nselect    ::=   SELECT col_list [limit]\n              | SELECT col_list WHERE cond_list [limit]\n              | SELECT col_list ORDER BY order_list [limit]\n              | SELECT col_list WHERE cond_list ORDER BY order_list [limit]\n              ;\n\nupdate    ::=   UPDATE SET upd_list\n              | UPDATE SET upd_list WHERE cond_list\n              ;\n\ndelete    ::=   DELETE WHERE cond_list\n              ;\n\ncol_list  ::= col_list COMMA col | col;\n\ncol       ::=   * \n              | COLUMN\n              | COLUMN AS COLUMN\n              ;\n\nupd_list  ::= upd_list COMMA upd | upd;\n\nupd       ::=   COLUMN = value\n              ;\n\norder_list::= order_list COMMA order | order;\n\norder     ::=   COLUMN\n              | COLUMN ASC\n              | COLUMN DESC\n              ;\n              \ncond_list ::=   cond_list cond \n              | cond\n              ;\n\ncond      ::=   COLUMN < NUMBER\n              | COLUMN <= NUMBER\n              | COLUMN = NUMBER\n              | COLUMN <> NUMBER\n              | COLUMN >= NUMBER\n              | COLUMN > NUMBER\n              | COLUMN REGEXP STRING\n              | COLUMN = STRING\n              | COLUMN IS NULL\n              | ( cond )\n              | cond:c1 AND cond:c2\n              | cond:c1 OR cond:c2\n              | NOT cond\n              ;\n\nvalue     ::=   NUMBER\n              | STRING\n              ;\n\nlimit     ::=   LIMIT NUMBER:max\n              | LIMIT NUMBER:offset , NUMBER:max\n              ;\n";
    }

    protected String getDefaultExpression() {
        return "SELECT *";
    }

    public String expressionTipText() {
        return "The spreadsheet query to evaluate.";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The spreadsheet reader for loading the spreadsheet to work on.";
    }

    public void setInput(PlaceholderFile value) {
        this.m_Input = value;
    }

    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    public String inputTipText() {
        return "The input file to load with the specified reader; ignored if pointing to directory.";
    }

    public void setSheet(SpreadSheet value) {
        this.m_Sheet = value;
    }

    public SpreadSheet getSheet() {
        return this.m_Sheet;
    }

    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to parse the value of symbol '" + name + "': " + value, e);
        }
        return result;
    }

    protected SpreadSheet doEvaluate(HashMap symbols) throws Exception {
        return SpreadSheetQuery.evaluate(this.m_Expression, symbols, this.m_Sheet);
    }

    protected void loadSheet() {
        if (this.m_Input.exists() && !this.m_Input.isDirectory()) {
            this.m_Sheet = this.m_Reader.read((File)this.m_Input);
        }
    }

    public SpreadSheet evaluate() throws Exception {
        this.loadSheet();
        return (SpreadSheet)super.evaluate();
    }

    public static SpreadSheet evaluate(String expr, HashMap symbols, SpreadSheet sheet) throws Exception {
        if ((expr = expr.trim()).startsWith("=")) {
            expr = expr.substring(1);
        }
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.setSheet(sheet);
        parser.parse();
        return parser.getResult();
    }

    public static void main(String[] args) {
        SpreadSheetQuery.runEvaluator(SpreadSheetQuery.class, (String[])args);
    }
}

