/*
 * Decompiled with CFR 0.152.
 */
package adams.parser.spreadsheetquery;

import adams.core.Range;
import adams.core.Utils;
import adams.core.base.BaseBoolean;
import adams.data.conversion.Conversion;
import adams.data.conversion.MultiConversion;
import adams.data.conversion.RenameSpreadSheetColumn;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.rowfinder.ByIndex;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SpreadSheetReorderColumns;
import adams.flow.transformer.SpreadSheetRowFilter;
import adams.flow.transformer.SpreadSheetSetCell;
import adams.flow.transformer.SpreadSheetSort;
import adams.flow.transformer.SpreadSheetSubset;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ParserHelper
extends adams.parser.ParserHelper {
    private static final long serialVersionUID = 8273216839178554659L;
    protected SpreadSheet m_Sheet;
    protected boolean m_AllColumns;
    protected boolean m_Select;
    protected boolean m_Delete;
    protected boolean m_Update;
    protected List<String> m_Columns;
    protected HashMap<String, String> m_RenameColumns;
    protected List<String> m_SortColumns;
    protected HashMap<String, Object> m_UpdateColumns;
    protected List<Boolean> m_SortAsc;
    protected List<RowFinder> m_RowFinders;
    protected SubProcess m_SubProcess;
    protected int[] m_Rows;
    protected int m_LimitMax;
    protected int m_LimitOffset;

    protected void initialize() {
        super.initialize();
        this.m_Sheet = null;
        this.m_AllColumns = false;
        this.m_Select = false;
        this.m_Delete = false;
        this.m_Update = false;
        this.m_Columns = new ArrayList<String>();
        this.m_RenameColumns = new HashMap();
        this.m_UpdateColumns = new HashMap();
        this.m_SortColumns = new ArrayList<String>();
        this.m_SortAsc = new ArrayList<Boolean>();
        this.m_RowFinders = new ArrayList<RowFinder>();
        this.m_SubProcess = null;
        this.m_Rows = null;
        this.m_LimitOffset = 0;
        this.m_LimitMax = -1;
    }

    public void setSheet(SpreadSheet value) {
        this.m_Sheet = value;
    }

    public SpreadSheet getSheet() {
        return this.m_Sheet;
    }

    public void useAllColumns() {
        this.m_AllColumns = true;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("all columns");
        }
    }

    public void addColumn(String col) {
        this.m_Columns.add(SpreadSheetColumnRange.escapeColumnName((String)col));
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("column: " + col);
        }
    }

    public void renameColumn(String col, String newCol) {
        this.m_RenameColumns.put(col, newCol);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("rename: " + col + " -> " + newCol);
        }
    }

    public void addSortColumn(String col, boolean asc) {
        this.m_SortColumns.add(col);
        this.m_SortAsc.add(asc);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("sort: " + col + ", asc: " + asc);
        }
    }

    public void addUpdateColumn(String col, Object value) {
        this.m_UpdateColumns.put(col, value);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("update: " + col + " = " + value);
        }
    }

    public int[] applyRowFinder(RowFinder finder, String log) {
        int[] result = finder.findRows(this.m_Sheet);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine(log + ": " + Utils.arrayToString((Object)result));
        }
        return result;
    }

    public void select() {
        this.m_Select = true;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("select");
        }
    }

    public void delete() {
        this.m_Delete = true;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("delete");
        }
    }

    public void update() {
        this.m_Update = true;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("update");
        }
    }

    public int[] combineWithAnd(int[] c1, int[] c2) {
        TIntHashSet set = new TIntHashSet(c1);
        set.retainAll(c2);
        int[] result = set.toArray();
        Arrays.sort(result);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("and: " + Utils.arrayToString((Object)result));
        }
        return result;
    }

    public int[] combineWithOr(int[] c1, int[] c2) {
        TIntHashSet set = new TIntHashSet(c1);
        set.addAll(c2);
        int[] result = set.toArray();
        Arrays.sort(result);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("or: " + Utils.arrayToString((Object)result));
        }
        return result;
    }

    public int[] invert(int[] c) {
        TIntHashSet set = new TIntHashSet(c);
        TIntArrayList list = new TIntArrayList(this.m_Sheet.getRowCount() - c.length);
        for (int i = 0; i < this.m_Sheet.getRowCount(); ++i) {
            if (set.contains(i)) continue;
            list.add(i);
        }
        int[] result = list.toArray();
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("not: " + Utils.arrayToString((Object)result));
        }
        return result;
    }

    public void setLimit(int offset, int max) {
        if (offset < 0) {
            offset = 0;
        }
        if (max < 1) {
            max = 1;
        }
        this.m_LimitOffset = offset;
        this.m_LimitMax = max;
    }

    public void setRows(int[] value) {
        this.m_Rows = value;
    }

    public int[] getRows() {
        return this.m_Rows;
    }

    public SubProcess getSubProcess() {
        return this.m_SubProcess;
    }

    public SpreadSheet getResult() {
        SpreadSheet result = null;
        this.m_SubProcess = null;
        SpreadSheetRowFilter rowFilter = new SpreadSheetRowFilter();
        ByIndex byIndex = new ByIndex();
        Range rows = new Range();
        if (this.m_Rows == null) {
            rows.setRange("first-last");
        } else {
            rows.setIndices(this.m_Rows);
        }
        byIndex.setRows(rows);
        rowFilter.setFinder(byIndex);
        SubProcess sub = new SubProcess();
        if (this.m_Select) {
            if (this.m_SortColumns.size() > 0) {
                SpreadSheetSort sort = new SpreadSheetSort();
                SpreadSheetColumnIndex[] cols = new SpreadSheetColumnIndex[this.m_SortColumns.size()];
                BaseBoolean[] order = new BaseBoolean[this.m_SortColumns.size()];
                for (int i = 0; i < this.m_SortColumns.size(); ++i) {
                    cols[i] = new SpreadSheetColumnIndex(this.m_SortColumns.get(i));
                    order[i] = new BaseBoolean("" + this.m_SortAsc.get(i));
                }
                sort.setSortColumn(cols);
                sort.setSortOrder(order);
                sub.add((AbstractActor)sort);
            }
            if (!this.m_AllColumns) {
                SpreadSheetReorderColumns reorder = new SpreadSheetReorderColumns();
                reorder.setOrder(Utils.flatten(this.m_Columns, (String)","));
                sub.add((AbstractActor)reorder);
            }
            if (this.m_RenameColumns.size() > 0) {
                Convert conv = new Convert();
                MultiConversion multi = new MultiConversion();
                ArrayList<RenameSpreadSheetColumn> list = new ArrayList<RenameSpreadSheetColumn>();
                for (String col : this.m_RenameColumns.keySet()) {
                    RenameSpreadSheetColumn ren = new RenameSpreadSheetColumn();
                    ren.setColumn(new SpreadSheetColumnIndex(col));
                    ren.setNewName(this.m_RenameColumns.get(col));
                    list.add(ren);
                }
                multi.setSubConversions(list.toArray(new Conversion[list.size()]));
                conv.setConversion((Conversion)multi);
                sub.add((AbstractActor)conv);
            }
            sub.add((AbstractActor)rowFilter);
            if (this.m_LimitMax > 0) {
                Range limit = new Range(this.m_LimitOffset + 1 + "-" + (this.m_LimitOffset + this.m_LimitMax));
                SpreadSheetSubset subset = new SpreadSheetSubset();
                subset.setRows(limit);
                subset.setColumns(new SpreadSheetColumnRange("first-last"));
                sub.add((AbstractActor)subset);
            }
        } else if (this.m_Update) {
            for (String col : this.m_UpdateColumns.keySet()) {
                SpreadSheetSetCell setcell = new SpreadSheetSetCell();
                setcell.setRow(rows);
                setcell.setColumn(new SpreadSheetColumnRange(col));
                setcell.setValue(this.m_UpdateColumns.get(col).toString());
                sub.add((AbstractActor)setcell);
            }
        } else if (this.m_Delete) {
            rows.setInverted(true);
            byIndex.setRows(rows);
            sub.add((AbstractActor)rowFilter);
        }
        this.m_SubProcess = (SubProcess)sub.shallowCopy();
        String msg = sub.setUp();
        if (msg == null) {
            sub.input(new Token((Object)this.getSheet()));
            msg = sub.execute();
            if (msg == null && sub.hasPendingOutput()) {
                result = (SpreadSheet)sub.output().getPayload();
            }
        }
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return result;
    }
}

