/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.struct.FastQueue;
import boofcv.struct.GrowQueue_I32;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import boofcv.struct.feature.TupleDesc_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;

public class AssociateNearestNeighbor<D extends TupleDesc_F64>
implements AssociateDescription<D> {
    private NearestNeighbor<Integer> alg;
    private NnData<Integer> result = new NnData();
    private FastQueue<D> listDst;
    private FastQueue<Integer> indexes = new FastQueue<Integer>(0, Integer.class, false);
    private List<double[]> src = new ArrayList<double[]>();
    private FastQueue<AssociatedIndex> matches = new FastQueue<AssociatedIndex>(100, AssociatedIndex.class, true);
    private FindUnassociated unassociated = new FindUnassociated();
    private double maxDistance = -1.0;

    public AssociateNearestNeighbor(NearestNeighbor<Integer> alg, int featureDimension) {
        this.alg = alg;
        alg.init(featureDimension);
    }

    @Override
    public void setSource(FastQueue<D> listSrc) {
        if (((Integer[])this.indexes.data).length < listSrc.size()) {
            Integer[] a = new Integer[listSrc.size()];
            System.arraycopy(this.indexes.data, 0, a, 0, ((Integer[])this.indexes.data).length);
            for (int i = ((Integer[])this.indexes.data).length; i < a.length; ++i) {
                a[i] = i;
            }
            this.indexes.data = a;
            this.indexes.size = a.length;
        } else {
            this.indexes.size = listSrc.size();
        }
        this.src.clear();
        for (int i = 0; i < listSrc.size; ++i) {
            this.src.add(((TupleDesc_F64[])listSrc.data)[i].value);
        }
        this.alg.setPoints(this.src, this.indexes.toList());
    }

    @Override
    public void setDestination(FastQueue<D> listDst) {
        this.listDst = listDst;
    }

    @Override
    public void associate() {
        this.matches.reset();
        for (int i = 0; i < this.listDst.size; ++i) {
            if (!this.alg.findNearest(((TupleDesc_F64[])this.listDst.data)[i].value, this.maxDistance, this.result)) continue;
            int indexSrc = (Integer)this.result.data;
            this.matches.grow().setAssociation(indexSrc, i, this.result.distance);
        }
    }

    @Override
    public FastQueue<AssociatedIndex> getMatches() {
        return this.matches;
    }

    @Override
    public GrowQueue_I32 getUnassociatedSource() {
        return this.unassociated.checkSource(this.matches, this.src.size());
    }

    @Override
    public GrowQueue_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination(this.matches, this.listDst.size());
    }

    @Override
    public void setThreshold(double score) {
        this.maxDistance = score;
    }

    @Override
    public MatchScoreType getScoreType() {
        return MatchScoreType.NORM_ERROR;
    }

    @Override
    public boolean uniqueSource() {
        return false;
    }

    @Override
    public boolean uniqueDestination() {
        return true;
    }
}

