/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.ConvertTupleDesc;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageSingleBand;

public class DescribeRegionPointConvert<T extends ImageSingleBand, In extends TupleDesc, Out extends TupleDesc>
implements DescribeRegionPoint<T, Out> {
    DescribeRegionPoint<T, In> original;
    ConvertTupleDesc<In, Out> converter;
    In storage;

    public DescribeRegionPointConvert(DescribeRegionPoint<T, In> original, ConvertTupleDesc<In, Out> converter) {
        this.original = original;
        this.converter = converter;
        this.storage = original.createDescription();
    }

    @Override
    public void setImage(T image) {
        this.original.setImage(image);
    }

    @Override
    public Out createDescription() {
        return this.converter.createOutput();
    }

    @Override
    public int getDescriptionLength() {
        return this.original.getDescriptionLength();
    }

    @Override
    public boolean isInBounds(double x, double y, double orientation, double scale) {
        return this.original.isInBounds(x, y, orientation, scale);
    }

    @Override
    public Out process(double x, double y, double orientation, double scale, Out ret) {
        if (ret == null) {
            ret = this.converter.createOutput();
        }
        this.original.process(x, y, orientation, scale, this.storage);
        this.converter.convert(this.storage, ret);
        return ret;
    }

    @Override
    public boolean requiresScale() {
        return this.original.requiresScale();
    }

    @Override
    public boolean requiresOrientation() {
        return this.original.requiresOrientation();
    }

    @Override
    public Class<Out> getDescriptionType() {
        return this.converter.getOutputType();
    }
}

