/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.HoughTransformLinePolar;
import boofcv.alg.feature.detect.line.ImageLinePruneMerge;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.struct.FastQueue;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.line.LineParametric2D_F32;
import java.util.ArrayList;
import java.util.List;

public class DetectLineHoughPolar<I extends ImageSingleBand, D extends ImageSingleBand>
implements DetectLine<I> {
    HoughTransformLinePolar alg;
    NonMaxSuppression extractor;
    ImageGradient<I, D> gradient;
    float thresholdEdge;
    D derivX;
    D derivY;
    ImageFloat32 intensity = new ImageFloat32(1, 1);
    ImageUInt8 binary = new ImageUInt8(1, 1);
    ImageFloat32 suppressed = new ImageFloat32(1, 1);
    float pruneAngleTol;
    float pruneRangeTol;
    double resolutionRange;
    double resolutionAngle;
    int localMaxRadius;
    int maxLines;
    ImageLinePruneMerge post = new ImageLinePruneMerge();

    public DetectLineHoughPolar(int localMaxRadius, int minCounts, double resolutionRange, double resolutionAngle, float thresholdEdge, int maxLines, ImageGradient<I, D> gradient) {
        this.pruneAngleTol = (float)((double)(localMaxRadius + 1) * resolutionAngle);
        this.pruneRangeTol = (float)((double)(localMaxRadius + 1) * resolutionRange);
        this.localMaxRadius = localMaxRadius;
        this.gradient = gradient;
        this.thresholdEdge = thresholdEdge;
        this.resolutionRange = resolutionRange;
        this.resolutionAngle = resolutionAngle;
        this.maxLines = maxLines <= 0 ? Integer.MAX_VALUE : maxLines;
        this.extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(localMaxRadius, minCounts, 0, true));
        this.derivX = GeneralizedImageOps.createSingleBand(gradient.getDerivType(), 1, 1);
        this.derivY = GeneralizedImageOps.createSingleBand(gradient.getDerivType(), 1, 1);
    }

    @Override
    public List<LineParametric2D_F32> detect(I input) {
        if (((ImageSingleBand)this.derivX).width != ((ImageSingleBand)input).width || ((ImageSingleBand)this.derivY).height != ((ImageSingleBand)input).height) {
            double r = Math.sqrt(((ImageSingleBand)input).width * ((ImageSingleBand)input).width + ((ImageSingleBand)input).height * ((ImageSingleBand)input).height);
            int numBinsRange = (int)Math.ceil(r / this.resolutionRange);
            int numBinsAngle = (int)Math.ceil(Math.PI / this.resolutionAngle);
            this.alg = new HoughTransformLinePolar(this.extractor, numBinsRange, numBinsAngle);
            ((ImageSingleBand)this.derivX).reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            ((ImageSingleBand)this.derivY).reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            this.intensity.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            this.binary.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            this.suppressed.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        }
        this.gradient.process(input, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.intensity);
        GGradientToEdgeFeatures.nonMaxSuppressionCrude4(this.intensity, this.derivX, this.derivY, this.suppressed);
        ThresholdImageOps.threshold(this.suppressed, this.binary, this.thresholdEdge, false);
        this.alg.transform(this.binary);
        FastQueue<LineParametric2D_F32> lines = this.alg.extractLines();
        List<LineParametric2D_F32> ret = new ArrayList<LineParametric2D_F32>();
        for (int i = 0; i < lines.size; ++i) {
            ret.add(lines.get(i));
        }
        ret = this.pruneLines(input, ret);
        return ret;
    }

    private List<LineParametric2D_F32> pruneLines(I input, List<LineParametric2D_F32> ret) {
        float[] intensity = this.alg.getFoundIntensity();
        this.post.reset();
        for (int i = 0; i < ret.size(); ++i) {
            this.post.add(ret.get(i), intensity[i]);
        }
        this.post.pruneSimilar(this.pruneAngleTol, this.pruneRangeTol, ((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.post.pruneNBest(this.maxLines);
        return this.post.createList();
    }

    public HoughTransformLinePolar getTransform() {
        return this.alg;
    }

    public D getDerivX() {
        return this.derivX;
    }

    public D getDerivY() {
        return this.derivY;
    }

    public ImageFloat32 getEdgeIntensity() {
        return this.intensity;
    }

    public ImageUInt8 getBinary() {
        return this.binary;
    }
}

