/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import georegression.struct.se.Se3_F64;

public class MonocularPlaneVisualOdometryScaleInput<T extends ImageBase>
implements MonocularPlaneVisualOdometry<T> {
    double scaleFactor;
    MonoPlaneParameters scaleParameter = new MonoPlaneParameters();
    T scaled;
    MonocularPlaneVisualOdometry<T> alg;

    public MonocularPlaneVisualOdometryScaleInput(MonocularPlaneVisualOdometry<T> alg, double scaleFactor) {
        this.alg = alg;
        this.scaleFactor = scaleFactor;
        this.scaled = alg.getImageType().createImage(1, 1);
    }

    @Override
    public void setCalibration(MonoPlaneParameters param) {
        this.scaleParameter.intrinsic = new IntrinsicParameters(param.intrinsic);
        this.scaleParameter.planeToCamera = param.planeToCamera.copy();
        PerspectiveOps.scaleIntrinsic(this.scaleParameter.intrinsic, this.scaleFactor);
        ((ImageBase)this.scaled).reshape(this.scaleParameter.intrinsic.width, this.scaleParameter.intrinsic.height);
        this.alg.setCalibration(this.scaleParameter);
    }

    @Override
    public boolean process(T leftImage) {
        DistortImageOps.scale(leftImage, this.scaled, TypeInterpolate.BILINEAR);
        return this.alg.process(this.scaled);
    }

    @Override
    public ImageDataType<T> getImageType() {
        return this.alg.getImageType();
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return this.alg.isFault();
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return (Se3_F64)this.alg.getCameraToWorld();
    }
}

