/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.geo.DistanceModelMonoPixels;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.sfm.d3.VisOdomPixelDepthPnP;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sfm.Point2D3DTrack;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;

public class VisOdomPixelDepthPnP_to_DepthVisualOdometry<Vis extends ImageBase, Depth extends ImageSingleBand>
implements DepthVisualOdometry<Vis, Depth>,
AccessPointTracks3D {
    DepthSparse3D<Depth> sparse3D;
    VisOdomPixelDepthPnP<Vis> alg;
    DistanceModelMonoPixels<Se3_F64, Point2D3D> distance;
    ImageDataType<Vis> visualType;
    Class<Depth> depthType;
    boolean success;
    List<PointTrack> active = new ArrayList<PointTrack>();

    public VisOdomPixelDepthPnP_to_DepthVisualOdometry(DepthSparse3D<Depth> sparse3D, VisOdomPixelDepthPnP<Vis> alg, DistanceModelMonoPixels<Se3_F64, Point2D3D> distance, ImageDataType<Vis> visualType, Class<Depth> depthType) {
        this.sparse3D = sparse3D;
        this.alg = alg;
        this.distance = distance;
        this.visualType = visualType;
        this.depthType = depthType;
    }

    @Override
    public Point3D_F64 getTrackLocation(int index) {
        try {
            PointTrack t = this.alg.getTracker().getActiveTracks(null).get(index);
            return ((Point2D3D)t.getCookie()).getLocation();
        }
        catch (IndexOutOfBoundsException e) {
            return new Point3D_F64();
        }
    }

    @Override
    public long getTrackId(int index) {
        return this.active.get((int)index).featureId;
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        return this.active;
    }

    @Override
    public boolean isInlier(int index) {
        Point2D3DTrack t = (Point2D3DTrack)this.active.get(index).getCookie();
        return t.lastInlier == this.alg.getTick();
    }

    @Override
    public boolean isNew(int index) {
        PointTrack t = this.alg.getTracker().getActiveTracks(null).get(index);
        return this.alg.getTracker().getNewTracks(null).contains((Object)t);
    }

    @Override
    public void setCalibration(IntrinsicParameters paramVisual, PixelTransform_F32 visToDepth) {
        this.sparse3D.configure(paramVisual, visToDepth);
        PointTransform_F64 leftPixelToNorm = LensDistortionOps.transformRadialToNorm_F64(paramVisual);
        PointTransform_F64 leftNormToPixel = LensDistortionOps.transformNormToRadial_F64(paramVisual);
        this.alg.setPixelToNorm(leftPixelToNorm);
        this.alg.setNormToPixel(leftNormToPixel);
        this.distance.setIntrinsic(paramVisual.fx, paramVisual.fy, paramVisual.skew);
    }

    @Override
    public boolean process(Vis visual, Depth depth) {
        this.sparse3D.setDepthImage(depth);
        this.success = this.alg.process(visual);
        this.active.clear();
        this.alg.getTracker().getActiveTracks(this.active);
        return this.success;
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return !this.success;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getCurrToWorld();
    }

    @Override
    public ImageDataType<Vis> getVisualType() {
        return this.visualType;
    }

    @Override
    public Class<Depth> getDepthType() {
        return this.depthType;
    }
}

