/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.alg.denoise.DenoiseWavelet;
import boofcv.alg.denoise.ShrinkThresholdRule;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;

public abstract class SubbandShrink<I extends ImageSingleBand<I>>
implements DenoiseWavelet<I> {
    protected ShrinkThresholdRule<I> rule;

    protected SubbandShrink(ShrinkThresholdRule<I> rule) {
        this.rule = rule;
    }

    protected abstract Number computeThreshold(I var1);

    protected void performShrinkage(I transform, int numLevels) {
        for (int i = 0; i < numLevels; ++i) {
            int w = ((ImageSingleBand)transform).width;
            int h = ((ImageSingleBand)transform).height;
            int ww = w / 2;
            int hh = h / 2;
            ImageBase subband = ((ImageSingleBand)transform).subimage(ww, 0, w, hh);
            Number threshold = this.computeThreshold(subband);
            this.rule.process(subband, threshold);
            subband = ((ImageSingleBand)transform).subimage(0, hh, ww, h);
            threshold = this.computeThreshold(subband);
            this.rule.process(subband, threshold);
            subband = ((ImageSingleBand)transform).subimage(ww, hh, w, h);
            threshold = this.computeThreshold(subband);
            this.rule.process(subband, threshold);
            transform = ((ImageSingleBand)transform).subimage(0, 0, ww, hh);
        }
    }
}

