/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.alg.feature.detect.InvalidCalibrationTarget;
import boofcv.alg.feature.detect.chess.DetectChessSquaresBinary;
import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.feature.detect.quadblob.OrderPointsIntoGrid;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPoint;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.geometry.UtilPoint2D_I32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ddogleg.sorting.QuickSort_F64;

public class DetectChessCalibrationPoints<T extends ImageSingleBand, D extends ImageSingleBand> {
    private D derivX;
    private D derivY;
    private int numColsPoints;
    private int numRowsPoints;
    private int radius;
    private DetectChessSquaresBinary findBound;
    private ImageUInt8 binary = new ImageUInt8(1, 1);
    private ImageUInt8 eroded = new ImageUInt8(1, 1);
    private double userBinaryThreshold = -1.0;
    private double actualBinaryThreshold;
    private double relativeSizeThreshold;
    private GeneralFeatureIntensity<T, D> intensityAlg;
    private GeneralFeatureDetector<T, D> detectorAlg;
    private List<Point2D_F64> subpixel;
    private int expectedPoints;
    private ImageRectangle targetRect;
    private OrderPointsIntoGrid orderAlg = new OrderPointsIntoGrid();
    private boolean foundBound;
    private int[] histogram = new int[256];

    public DetectChessCalibrationPoints(int numCols, int numRows, int radius, double relativeSizeThreshold, Class<T> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        this.radius = radius;
        this.relativeSizeThreshold = relativeSizeThreshold;
        this.numColsPoints = numCols - 1;
        this.numRowsPoints = numRows - 1;
        this.expectedPoints = this.numColsPoints * this.numRowsPoints;
        this.derivX = GeneralizedImageOps.createSingleBand(derivType, 1, 1);
        this.derivY = GeneralizedImageOps.createSingleBand(derivType, 1, 1);
        this.intensityAlg = FactoryIntensityPoint.shiTomasi(radius, true, derivType);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(radius + 2, 20.0f, radius + 2, true));
        this.detectorAlg = new GeneralFeatureDetector<T, D>(this.intensityAlg, extractor);
        this.findBound = new DetectChessSquaresBinary(numCols, numRows, 0);
        this.reset();
    }

    public void reset() {
    }

    public boolean process(T gray) {
        this.targetRect = null;
        this.subpixel = new ArrayList<Point2D_F64>();
        this.binary.reshape(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        this.eroded.reshape(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        this.adjustForImageSize(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        this.foundBound = this.detectChessBoard(gray, this.userBinaryThreshold, true);
        if (!this.foundBound) {
            return false;
        }
        this.targetRect = this.findBound.getBoundRect();
        ImageBase subGray = ((ImageSingleBand)gray).subimage(this.targetRect.x0, this.targetRect.y0, this.targetRect.x1, this.targetRect.y1);
        ((ImageSingleBand)this.derivX).reshape(((ImageSingleBand)subGray).width, ((ImageSingleBand)subGray).height);
        ((ImageSingleBand)this.derivY).reshape(((ImageSingleBand)subGray).width, ((ImageSingleBand)subGray).height);
        GImageDerivativeOps.sobel(subGray, this.derivX, this.derivY, BorderType.EXTENDED);
        this.detectorAlg.process(subGray, this.derivX, this.derivY, null, null, null);
        QueueCorner corners = this.detectorAlg.getMaximums();
        List<Point2D_F64> points = this.convert(corners, this.targetRect.x0, this.targetRect.y0);
        this.pruneFarFromBlobCorners(points, this.findBound.getCandidatePoints());
        if (points.size() < this.expectedPoints) {
            return false;
        }
        points = this.selectBrightest(points, this.intensityAlg.getIntensity(), this.targetRect.x0, this.targetRect.y0);
        for (Point2D_F64 p : points) {
            this.subpixel.add(this.refineSubpixel(p, this.targetRect.x0, this.targetRect.y0, this.intensityAlg.getIntensity()));
        }
        try {
            this.orderAlg.process(this.subpixel);
        }
        catch (InvalidCalibrationTarget e) {
            System.err.println(e.getMessage());
            return false;
        }
        if (this.numColsPoints * this.numRowsPoints != this.orderAlg.getNumCols() * this.orderAlg.getNumRows()) {
            System.err.println("Unexpected grid size");
            return false;
        }
        this.subpixel = UtilCalibrationGrid.rotatePoints(this.orderAlg.getOrdered(), this.orderAlg.getNumRows(), this.orderAlg.getNumCols(), this.numRowsPoints, this.numColsPoints);
        return this.subpixel != null;
    }

    private void adjustForImageSize(int imgWidth, int imgHeight) {
        int size = (int)(this.relativeSizeThreshold * 40.0 / 640.0 * (double)imgWidth);
        if (size < 10) {
            size = 10;
        }
        this.findBound.setMinimumContourSize(size);
    }

    private boolean detectChessBoard(T gray, double threshold, boolean first) {
        this.actualBinaryThreshold = threshold;
        if (this.actualBinaryThreshold < 0.0) {
            this.actualBinaryThreshold = UtilCalibrationGrid.selectThreshold(gray, this.histogram);
        }
        GThresholdImageOps.threshold(gray, this.binary, this.actualBinaryThreshold, true);
        BinaryImageOps.erode8(this.binary, this.eroded);
        if (this.findBound.process(this.eroded)) {
            if (this.userBinaryThreshold < 0.0) {
                return this.detectChessBoardSubImage(gray);
            }
            return true;
        }
        if (first && this.userBinaryThreshold < 0.0) {
            threshold = (255.0 + threshold) / 2.0;
            return this.detectChessBoard(gray, threshold, false);
        }
        return false;
    }

    private boolean detectChessBoardSubImage(T gray) {
        ImageRectangle targetBound = this.findBound.getBoundRect();
        int w = targetBound.getWidth();
        int h = targetBound.getHeight();
        ImageRectangle expanded = new ImageRectangle();
        int adj = (int)((double)w * 0.12);
        expanded.x0 = targetBound.x0 - adj;
        expanded.x1 = targetBound.x1 + adj;
        adj = (int)((double)h * 0.12);
        expanded.y0 = targetBound.y0 - adj;
        expanded.y1 = targetBound.y1 + adj;
        BoofMiscOps.boundRectangleInside(gray, expanded);
        ImageBase subGray = ((ImageSingleBand)gray).subimage(expanded.x0, expanded.y0, expanded.x1, expanded.y1);
        this.actualBinaryThreshold = UtilCalibrationGrid.selectThreshold((ImageSingleBand)subGray, this.histogram);
        GImageMiscOps.fill(this.binary, 0.0);
        ImageUInt8 subBinary = (ImageUInt8)this.binary.subimage(expanded.x0, expanded.y0, expanded.x1, expanded.y1);
        GThresholdImageOps.threshold(subGray, subBinary, this.actualBinaryThreshold, true);
        BinaryImageOps.erode8(this.binary, this.eroded);
        BinaryImageOps.erode4(this.eroded, this.binary);
        BinaryImageOps.dilate4(this.binary, this.eroded);
        return this.findBound.process(this.eroded);
    }

    private Point2D_F64 refineSubpixel(Point2D_F64 pt, int x0, int y0, ImageFloat32 intensity) {
        int r = this.radius + 3;
        ImageRectangle area = new ImageRectangle((int)(pt.x - (double)r - (double)x0), (int)(pt.y - (double)r - (double)y0), (int)(pt.x + (double)r - (double)x0 + 1.0), (int)(pt.y + (double)r + 1.0 - (double)y0));
        BoofMiscOps.boundRectangleInside(intensity, area);
        float meanX = 0.0f;
        float meanY = 0.0f;
        float sum = 0.0f;
        for (int i = area.y0; i < area.y1; ++i) {
            for (int j = area.x0; j < area.x1; ++j) {
                float value = intensity.get(j, i);
                meanX += (float)j * value;
                meanY += (float)i * value;
                sum += value;
            }
        }
        return new Point2D_F64((double)((float)x0 + (meanX /= sum)), (double)((float)y0 + (meanY /= sum)));
    }

    private List<Point2D_I32> orderPoints(List<Point2D_I32> predicted, List<Point2D_I32> detected) {
        ArrayList<Point2D_I32> ret = new ArrayList<Point2D_I32>();
        for (Point2D_I32 p : predicted) {
            double bestDist = Double.MAX_VALUE;
            Point2D_I32 best = null;
            for (Point2D_I32 d : detected) {
                double dist = UtilPoint2D_I32.distance((Point2D_I32)p, (Point2D_I32)d);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
                best = d;
            }
            ret.add(best);
        }
        return ret;
    }

    private void pruneFarFromBlobCorners(List<Point2D_F64> corners, List<Point2D_I32> initial) {
        int tolerance = 10;
        Iterator<Point2D_F64> iter = corners.iterator();
        while (iter.hasNext()) {
            Point2D_F64 c = iter.next();
            int x = (int)c.x;
            int y = (int)c.y;
            boolean matched = false;
            for (Point2D_I32 i : initial) {
                if (!(UtilPoint2D_I32.distance((int)x, (int)y, (int)i.x, (int)i.y) < (double)tolerance)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            iter.remove();
        }
    }

    private List<Point2D_F64> convert(QueueCorner found, int x0, int y0) {
        ArrayList<Point2D_F64> points = new ArrayList<Point2D_F64>();
        for (int i = 0; i < found.size(); ++i) {
            Point2D_I16 c = (Point2D_I16)found.get(i);
            points.add(new Point2D_F64((double)(c.x + x0), (double)(c.y + y0)));
        }
        return points;
    }

    private List<Point2D_F64> selectBrightest(List<Point2D_F64> points, ImageFloat32 intensity, int offX, int offY) {
        if (points.size() == this.expectedPoints) {
            return points;
        }
        double[] values = new double[points.size()];
        int[] indexes = new int[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            values[i] = -intensity.get((int)(p.x - (double)offX), (int)(p.y - (double)offY));
        }
        new QuickSort_F64().sort(values, points.size(), indexes);
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        for (int i = 0; i < this.expectedPoints; ++i) {
            ret.add(points.get(indexes[i]));
        }
        return ret;
    }

    public void renderIntensity(ImageFloat32 wholeImage) {
        if (this.targetRect == null) {
            ImageMiscOps.fill(wholeImage, 0.0f);
        } else {
            ImageFloat32 found = this.intensityAlg.getIntensity();
            ImageFloat32 out = (ImageFloat32)wholeImage.subimage(this.targetRect.x0, this.targetRect.y0, this.targetRect.x1, this.targetRect.y1);
            out.setTo(found);
        }
    }

    public DetectChessSquaresBinary getFindBound() {
        return this.findBound;
    }

    public List<Point2D_F64> getPoints() {
        return this.subpixel;
    }

    public ImageUInt8 getBinary() {
        return this.eroded;
    }

    public double getActualBinaryThreshold() {
        return this.actualBinaryThreshold;
    }

    public void setUserBinaryThreshold(double userBinaryThreshold) {
        this.userBinaryThreshold = userBinaryThreshold;
    }

    public double getUserBinaryThreshold() {
        return this.userBinaryThreshold;
    }

    public boolean isFoundBound() {
        return this.foundBound;
    }

    public List<Point2D_F64> detectedPointFeatures() {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        int offX = this.targetRect.x0;
        int offY = this.targetRect.y0;
        QueueCorner found = this.detectorAlg.getMaximums();
        for (int i = 0; i < found.size; ++i) {
            Point2D_I16 c = (Point2D_I16)found.get(i);
            ret.add(new Point2D_F64((double)(offX + c.x), (double)(offY + c.y)));
        }
        return ret;
    }
}

