/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageFloat32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.sorting.QuickSelectArray;

public class SelectNBestFeatures {
    QueueCorner bestCorners;
    int[] indexes = new int[1];
    float[] inten = new float[1];
    int target;

    public SelectNBestFeatures(int N) {
        this.bestCorners = new QueueCorner(N);
        this.setN(N);
    }

    public void setN(int N) {
        this.target = N;
    }

    public void process(ImageFloat32 intensityImage, QueueCorner origCorners, boolean positive) {
        this.bestCorners.reset();
        if (origCorners.size <= this.target) {
            for (int i = 0; i < origCorners.size; ++i) {
                Point2D_I16 pt = ((Point2D_I16[])origCorners.data)[i];
                this.bestCorners.add(pt.x, pt.y);
            }
        } else {
            Point2D_I16 pt;
            int i;
            if (origCorners.size > this.indexes.length) {
                this.indexes = new int[origCorners.size];
                this.inten = new float[origCorners.size];
            }
            Point2D_I16[] points = (Point2D_I16[])origCorners.data;
            if (positive) {
                for (i = 0; i < origCorners.size; ++i) {
                    pt = points[i];
                    this.inten[i] = -intensityImage.get(pt.getX(), pt.getY());
                }
            } else {
                for (i = 0; i < origCorners.size; ++i) {
                    pt = points[i];
                    this.inten[i] = intensityImage.get(pt.getX(), pt.getY());
                }
            }
            QuickSelectArray.selectIndex((float[])this.inten, (int)this.target, (int)origCorners.size, (int[])this.indexes);
            for (i = 0; i < this.target; ++i) {
                pt = ((Point2D_I16[])origCorners.data)[this.indexes[i]];
                this.bestCorners.add(pt.x, pt.y);
            }
        }
    }

    public QueueCorner getBestCorners() {
        return this.bestCorners;
    }
}

