/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.alg.feature.detect.grid.DetectSquareCalibrationPoints;
import boofcv.alg.feature.detect.grid.FitGaussianPrune;
import boofcv.alg.feature.detect.grid.HistogramTwoPeaks;
import boofcv.alg.feature.detect.grid.IntensityHistogram;
import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class AutoThresholdCalibrationGrid {
    private double initialThreshold;
    private double refinedThreshold;
    private ImageUInt8 binary = new ImageUInt8(1, 1);
    private IntensityHistogram histHighRes = new IntensityHistogram(256, 256.0);
    private IntensityHistogram histLowRes = new IntensityHistogram(20, 256.0);
    private HistogramTwoPeaks peaks = new HistogramTwoPeaks(2);
    private FitGaussianPrune low = new FitGaussianPrune(20, 3.0, 5);
    private FitGaussianPrune high = new FitGaussianPrune(20, 3.0, 5);
    private int[] histogram = new int[256];

    public AutoThresholdCalibrationGrid(double initialThreshold) {
        this.initialThreshold = initialThreshold;
    }

    public boolean process(DetectSquareCalibrationPoints detector, ImageFloat32 gray) {
        this.binary.reshape(gray.width, gray.height);
        double threshold = this.initialThreshold;
        if (threshold < 0.0) {
            threshold = UtilCalibrationGrid.selectThreshold(gray, this.histogram);
        }
        GThresholdImageOps.threshold(gray, this.binary, threshold, true);
        if (detector.process(this.binary)) {
            this.refinedThreshold = this.refineThreshold(detector.getInterestSquares(), gray);
            GThresholdImageOps.threshold(gray, this.binary, threshold, true);
            if (!detector.process(this.binary)) {
                throw new RuntimeException("Crap new threshold doesn't work!");
            }
            return true;
        }
        return false;
    }

    public double getThreshold() {
        return this.refinedThreshold;
    }

    private double refineThreshold(List<QuadBlob> blobs, ImageFloat32 gray) {
        this.histHighRes.reset();
        for (QuadBlob b : blobs) {
            int r = (int)Math.ceil(b.smallestSide) / 3;
            for (Point2D_I32 p : b.corners) {
                ImageRectangle rect = new ImageRectangle(p.x - r, p.y - r, p.x + r + 1, p.y + r + 1);
                BoofMiscOps.boundRectangleInside(gray, rect);
                for (int y = rect.y0; y < rect.y1; ++y) {
                    for (int x = rect.x0; x < rect.x1; ++x) {
                        this.histHighRes.add(gray.get(x, y));
                    }
                }
            }
        }
        this.histLowRes.reset();
        this.histLowRes.downSample(this.histHighRes);
        this.peaks.computePeaks(this.histLowRes);
        int indexThresh = (int)((this.peaks.peakLow + this.peaks.peakHigh) / 2.0);
        this.low.process(this.histHighRes, 0, indexThresh);
        this.high.process(this.histHighRes, indexThresh, 255);
        return (this.low.getMean() + this.high.getMean()) / 2.0;
    }

    public ImageUInt8 getBinary() {
        return this.binary;
    }
}

