/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid.refine;

import boofcv.alg.feature.detect.InvalidCalibrationTarget;
import boofcv.alg.feature.detect.grid.FitGaussianPrune;
import boofcv.alg.feature.detect.grid.HistogramTwoPeaks;
import boofcv.alg.feature.detect.grid.IntensityHistogram;
import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.struct.FastQueue;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import georegression.geometry.UtilPoint2D_F64;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.UtilOptimize;
import org.ddogleg.optimization.functions.FunctionNtoS;

public class RefineCornerSegmentFit {
    private FitGaussianPrune low = new FitGaussianPrune(20, 3.0, 5);
    private FitGaussianPrune high = new FitGaussianPrune(20, 3.0, 5);
    private ImageUInt8 regionWhite = new ImageUInt8(1, 1);
    private ImageUInt8 regionBlack = new ImageUInt8(1, 1);
    private ImageUInt8 binary = new ImageUInt8(1, 1);
    private ImageUInt8 binaryHigh = new ImageUInt8(1, 1);
    private ImageUInt8 binaryMiddle = new ImageUInt8(1, 1);
    private FastQueue<PointInfo> points = new FastQueue<PointInfo>(100, PointInfo.class, true);
    private ImageSInt32 blobs = new ImageSInt32(1, 1);
    private Point2D_I32[] pointsAlongEdge = new Point2D_I32[]{new Point2D_I32()};
    private int width;
    private int height;
    private int numEdges;
    private InitialEstimate initial = new InitialEstimate();
    private CostFunction func = new CostFunction();
    private UnconstrainedMinimization alg = FactoryOptimization.unconstrained();
    private Point2D_F64 corner;
    IntensityHistogram histHighRes = new IntensityHistogram(256, 256.0);
    IntensityHistogram histLowRes = new IntensityHistogram(20, 256.0);
    HistogramTwoPeaks peaks = new HistogramTwoPeaks(6);

    public void process(ImageFloat32 image) {
        this.init(image);
        this.computeStatistics(image);
        this.detectEdgePoints(image);
        this.selectEdgeParam(image);
        this.selectCornerParam();
        this.corner = this.optimizeFit();
    }

    public Point2D_F64 getCorner() {
        return this.corner;
    }

    private void init(ImageFloat32 image) {
        this.width = image.width;
        this.height = image.height;
        this.numEdges = 2 * (this.width + this.height - 2);
        this.regionWhite.reshape(this.width, this.height);
        this.regionBlack.reshape(this.width, this.height);
        this.binaryHigh.reshape(this.width, this.height);
        this.binaryMiddle.reshape(this.width, this.height);
        this.binary.reshape(this.width, this.height);
        this.blobs.reshape(this.width, this.height);
        this.setupEdgeArray();
    }

    private void computeStatistics(ImageFloat32 image) {
        this.histHighRes.reset();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.histHighRes.add(image.get(x, y));
            }
        }
        this.histLowRes.reset();
        this.histLowRes.downSample(this.histHighRes);
        this.peaks.computePeaks(this.histLowRes);
        int indexThresh = (int)((this.peaks.peakLow + this.peaks.peakHigh) / 2.0);
        this.low.process(this.histHighRes, 0, indexThresh);
        this.high.process(this.histHighRes, indexThresh, 255);
    }

    private void setupEdgeArray() {
        int i;
        if (this.pointsAlongEdge.length < this.numEdges) {
            this.pointsAlongEdge = new Point2D_I32[this.numEdges];
            for (int i2 = 0; i2 < this.numEdges; ++i2) {
                this.pointsAlongEdge[i2] = new Point2D_I32();
            }
        }
        int index = 0;
        for (i = 0; i < this.width; ++i) {
            this.pointsAlongEdge[index++].set(i, 0);
        }
        for (i = 1; i < this.height - 1; ++i) {
            this.pointsAlongEdge[index++].set(this.width - 1, i);
        }
        for (i = this.width - 1; i >= 0; --i) {
            this.pointsAlongEdge[index++].set(i, this.height - 1);
        }
        for (i = this.height - 2; i >= 1; --i) {
            this.pointsAlongEdge[index++].set(0, i);
        }
    }

    private void detectEdgePoints(ImageFloat32 image) {
        double lowThresh = this.low.getMean() + this.low.getSigma() * 3.0 + 1.0;
        double highThresh = this.high.getMean() - this.high.getSigma() * 3.0 - 1.0;
        if (highThresh <= lowThresh) {
            throw new InvalidCalibrationTarget("Bad statistics");
        }
        double middleThresh = lowThresh * 0.5 + highThresh * 0.5;
        GThresholdImageOps.threshold(image, this.binaryMiddle, middleThresh, true);
        this.removeBinaryNoise(this.binaryMiddle);
        GThresholdImageOps.threshold(image, this.binaryHigh, highThresh, true);
        this.removeBinaryNoise(this.binaryHigh);
        BinaryImageOps.logicXor(this.binaryMiddle, this.binaryHigh, this.binaryHigh);
        BinaryImageOps.edge4(this.binaryMiddle, this.binary);
        BinaryImageOps.logicOr(this.binaryHigh, this.binary, this.binary);
        this.points.reset();
        double middle = (this.high.getMean() + this.low.getMean()) / 2.0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.binary.get(x, y) != 1) continue;
                PointInfo p = this.points.grow();
                p.set(x, y);
                double v = image.get(x, y);
                p.weight = 1.0 - Math.abs(middle - v) / middle;
                p.weight *= p.weight;
            }
        }
    }

    private void removeBinaryNoise(ImageUInt8 binary) {
        List<Contour> contours = BinaryImageOps.contour(binary, 4, this.blobs);
        Contour largest = null;
        for (Contour c : contours) {
            if (largest != null && largest.external.size() >= c.external.size()) continue;
            largest = c;
        }
        if (largest == null) {
            return;
        }
        int[] labels = new int[contours.size() + 1];
        labels[largest.id] = 1;
        BinaryImageOps.relabel(this.blobs, labels);
        BinaryImageOps.labelToBinary(this.blobs, binary);
    }

    private Point2D_F64 optimizeFit() {
        double[] param = new double[]{this.initial.corner.x, this.initial.corner.y, Math.atan2((double)this.initial.sideA.y - this.initial.corner.y, (double)this.initial.sideA.x - this.initial.corner.x), Math.atan2((double)this.initial.sideB.y - this.initial.corner.y, (double)this.initial.sideB.x - this.initial.corner.x)};
        this.alg.setFunction((FunctionNtoS)this.func, null, 0.0);
        this.alg.initialize(param, 0.0, 1.0E-8);
        if (!UtilOptimize.process((UnconstrainedMinimization)this.alg, (int)500)) {
            throw new InvalidCalibrationTarget("Minimization failed?!? " + this.alg.getWarning());
        }
        double[] found = this.alg.getParameters();
        return new Point2D_F64(found[0], found[1]);
    }

    private void selectEdgeParam(ImageFloat32 image) {
        ArrayList<Integer> onEdge = new ArrayList<Integer>();
        for (int i = 0; i < this.numEdges; ++i) {
            Point2D_I32 p = this.pointsAlongEdge[i];
            if (this.binary.get(p.x, p.y) != 1) continue;
            onEdge.add(i);
        }
        if (onEdge.size() < 2) {
            throw new InvalidCalibrationTarget("Less than two edge points");
        }
        int bestDistance = -1;
        int bestA = -1;
        int bestB = -1;
        for (int i = 0; i < onEdge.size(); ++i) {
            int first = (Integer)onEdge.get(i);
            for (int j = i + 1; j < onEdge.size(); ++j) {
                int second = (Integer)onEdge.get(j);
                int distance = UtilCalibrationGrid.distanceCircle(first, second, this.numEdges);
                if (distance <= bestDistance) continue;
                bestDistance = distance;
                bestA = first;
                bestB = second;
            }
        }
        this.initial.sideA = this.pointsAlongEdge[bestA];
        this.initial.sideB = this.pointsAlongEdge[bestB];
    }

    private void selectCornerParam() {
        Point2D_I32 a = this.initial.sideA;
        Point2D_I32 b = this.initial.sideB;
        PointInfo bestPoint = null;
        double bestDist = -1.0;
        for (int i = 0; i < this.points.size(); ++i) {
            double distB;
            PointInfo p = this.points.get(i);
            double distA = UtilPoint2D_F64.distance((double)a.x, (double)a.y, (double)p.x, (double)p.y);
            double sum = distA + (distB = UtilPoint2D_F64.distance((double)b.x, (double)b.y, (double)p.x, (double)p.y));
            if (!(sum > bestDist)) continue;
            bestDist = sum;
            bestPoint = p;
        }
        this.initial.corner = bestPoint;
    }

    public static class PointInfo
    extends Point2D_F64 {
        public double weight;
    }

    private class CostFunction
    implements FunctionNtoS {
        LineParametric2D_F64 lineA = new LineParametric2D_F64();
        LineParametric2D_F64 lineB = new LineParametric2D_F64();

        private CostFunction() {
        }

        public int getN() {
            return 4;
        }

        public double process(double[] input) {
            double x = input[0];
            double y = input[1];
            double thetaA = input[2];
            double thetaB = input[3];
            this.lineA.p.set(x, y);
            this.lineB.p.set(x, y);
            this.lineA.slope.set(Math.cos(thetaA), Math.sin(thetaA));
            this.lineB.slope.set(Math.cos(thetaB), Math.sin(thetaB));
            double cost = 0.0;
            for (int i = 0; i < ((RefineCornerSegmentFit)RefineCornerSegmentFit.this).points.size; ++i) {
                PointInfo p = (PointInfo)((Object)RefineCornerSegmentFit.this.points.get(i));
                double distA = Distance2D_F64.distanceSq((LineParametric2D_F64)this.lineA, (Point2D_F64)p);
                double distB = Distance2D_F64.distanceSq((LineParametric2D_F64)this.lineB, (Point2D_F64)p);
                cost += p.weight * Math.min(distA, distB);
            }
            return cost;
        }
    }

    private static class InitialEstimate {
        Point2D_I32 sideA;
        Point2D_I32 sideB;
        Point2D_F64 corner;

        private InitialEstimate() {
        }
    }
}

