/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.quadblob;

import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;

public class QuadBlob {
    public List<Point2D_I32> contour;
    public List<Point2D_I32> corners;
    public List<Point2D_F64> subpixel;
    public Point2D_I32 center;
    public double largestSide;
    public double smallestSide;
    public double[] sideLengths = new double[4];
    public List<QuadBlob> conn = new ArrayList<QuadBlob>();

    public QuadBlob(List<Point2D_I32> contour, List<Point2D_I32> corners) {
        this();
        this.contour = contour;
        this.corners = corners;
        this.center = UtilCalibrationGrid.findAverage(contour);
        this.compute();
    }

    public QuadBlob() {
        this.subpixel = new ArrayList<Point2D_F64>();
        for (int i = 0; i < 4; ++i) {
            this.subpixel.add(new Point2D_F64());
        }
    }

    public void compute() {
        Point2D_I32 a = this.corners.get(0);
        Point2D_I32 b = this.corners.get(1);
        Point2D_I32 c = this.corners.get(2);
        Point2D_I32 d = this.corners.get(3);
        this.sideLengths[0] = Math.sqrt(a.distance2(b));
        this.sideLengths[1] = Math.sqrt(b.distance2(c));
        this.sideLengths[2] = Math.sqrt(c.distance2(d));
        this.sideLengths[3] = Math.sqrt(d.distance2(a));
        this.smallestSide = this.largestSide = this.sideLengths[0];
        for (int i = 1; i < 4; ++i) {
            if (this.largestSide < this.sideLengths[i]) {
                this.largestSide = this.sideLengths[i];
                continue;
            }
            if (!(this.smallestSide > this.sideLengths[i])) continue;
            this.smallestSide = this.sideLengths[i];
        }
    }
}

