/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.ImageSingleBand;

public abstract class OrientationImageAverage<T extends ImageSingleBand>
implements OrientationImage<T> {
    protected T image;
    protected ImageRectangle rect = new ImageRectangle();
    protected int radius;
    protected int radiusScale;
    protected Kernel2D_F32 kerCosine;
    protected Kernel2D_F32 kerSine;

    public OrientationImageAverage(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void setImage(T image) {
        this.image = image;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.setScale(1.0);
    }

    @Override
    public void setScale(double scale) {
        this.radiusScale = (int)Math.ceil(scale * (double)this.radius);
        int w = this.radiusScale * 2 + 1;
        this.kerCosine = new Kernel2D_F32(w);
        this.kerSine = new Kernel2D_F32(w);
        for (int y = -this.radiusScale; y <= this.radiusScale; ++y) {
            int pixelY = y + this.radiusScale;
            for (int x = -this.radiusScale; x <= this.radiusScale; ++x) {
                int pixelX = x + this.radiusScale;
                float r = (float)Math.sqrt(x * x + y * y);
                this.kerCosine.set(pixelX, pixelY, (float)x / r);
                this.kerSine.set(pixelX, pixelY, (float)y / r);
            }
        }
        this.kerCosine.set(this.radiusScale, this.radiusScale, 0.0f);
        this.kerSine.set(this.radiusScale, this.radiusScale, 0.0f);
    }

    @Override
    public double compute(double X, double Y) {
        int c_x = (int)X;
        int c_y = (int)Y;
        this.rect.x0 = c_x - this.radiusScale;
        this.rect.y0 = c_y - this.radiusScale;
        this.rect.x1 = c_x + this.radiusScale + 1;
        this.rect.y1 = c_y + this.radiusScale + 1;
        BoofMiscOps.boundRectangleInside(this.image, this.rect);
        return this.computeAngle(c_x, c_y);
    }

    protected abstract double computeAngle(int var1, int var2);
}

