/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.abst.feature.orientation.OrientationGradient;
import boofcv.alg.InputSanityCheck;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.ImageSingleBand;

public abstract class OrientationSlidingWindow<D extends ImageSingleBand>
implements OrientationGradient<D> {
    protected int radius;
    protected int radiusScale;
    protected D derivX;
    protected D derivY;
    protected ImageRectangle rect = new ImageRectangle();
    protected int numAngles;
    protected double windowSize;
    protected double[] angles;
    protected boolean isWeighted;
    protected Kernel2D_F32 weights;

    public OrientationSlidingWindow(int numAngles, double windowSize, boolean isWeighted) {
        this.numAngles = numAngles;
        this.windowSize = windowSize;
        this.isWeighted = isWeighted;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.setScale(1.0);
    }

    public Kernel2D_F32 getWeights() {
        return this.weights;
    }

    @Override
    public void setScale(double scale) {
        this.radiusScale = (int)Math.ceil(scale * (double)this.radius);
        if (this.isWeighted) {
            this.weights = (Kernel2D_F32)FactoryKernelGaussian.gaussian(2, true, 32, -1.0, this.radiusScale);
        }
        int w = this.radiusScale * 2 + 1;
        this.angles = new double[w * w];
    }

    @Override
    public void setImage(D derivX, D derivY) {
        InputSanityCheck.checkSameShape(derivX, derivY);
        this.derivX = derivX;
        this.derivY = derivY;
    }

    @Override
    public double compute(double X, double Y) {
        int c_x = (int)X;
        int c_y = (int)Y;
        this.rect.x0 = c_x - this.radiusScale;
        this.rect.y0 = c_y - this.radiusScale;
        this.rect.x1 = c_x + this.radiusScale + 1;
        this.rect.y1 = c_y + this.radiusScale + 1;
        BoofMiscOps.boundRectangleInside(this.derivX, this.rect);
        if (this.isWeighted) {
            return this.computeWeightedOrientation(c_x, c_y);
        }
        return this.computeOrientation();
    }

    protected abstract double computeOrientation();

    protected abstract double computeWeightedOrientation(int var1, int var2);
}

