/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.struct.FastQueue;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class ContourTracer {
    private int rule;
    private FastQueue<Point2D_I32> storagePoints;
    private ImageUInt8 binary;
    private ImageSInt32 labeled;
    private List<Point2D_I32> contour;
    private int x;
    private int y;
    private int label;
    private int dir;
    private int indexBinary;
    private int indexLabel;
    private int[] offsetsBinary;
    private int[] offsetsLabeled;
    private int[] nextDirection;

    public ContourTracer(int rule) {
        if (rule != 4 && rule != 8) {
            throw new IllegalArgumentException("Connectivity rule must be 4 or 8 not " + rule);
        }
        this.rule = rule;
        this.offsetsBinary = new int[rule];
        this.offsetsLabeled = new int[rule];
        if (rule == 8) {
            this.nextDirection = new int[8];
            for (int i = 0; i < 8; ++i) {
                this.nextDirection[i] = ((i + 4) % 8 + 2) % 8;
            }
        } else {
            this.nextDirection = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.nextDirection[i] = ((i + 2) % 4 + 1) % 4;
            }
        }
    }

    public void setInputs(ImageUInt8 binary, ImageSInt32 labeled, FastQueue<Point2D_I32> storagePoints) {
        this.binary = binary;
        this.labeled = labeled;
        this.storagePoints = storagePoints;
        if (this.rule == 8) {
            this.setOffsets8(this.offsetsBinary, binary.stride);
            this.setOffsets8(this.offsetsLabeled, labeled.stride);
        } else {
            this.setOffsets4(this.offsetsBinary, binary.stride);
            this.setOffsets4(this.offsetsLabeled, labeled.stride);
        }
    }

    private void setOffsets8(int[] offsets, int stride) {
        int s = stride;
        offsets[0] = 1;
        offsets[1] = 1 + s;
        offsets[2] = s;
        offsets[3] = -1 + s;
        offsets[4] = -1;
        offsets[5] = -1 - s;
        offsets[6] = -s;
        offsets[7] = 1 - s;
    }

    private void setOffsets4(int[] offsets, int stride) {
        int s = stride;
        offsets[0] = 1;
        offsets[1] = s;
        offsets[2] = -1;
        offsets[3] = -s;
    }

    public void trace(int label, int initialX, int initialY, boolean external, List<Point2D_I32> contour) {
        int initialDir = this.rule == 8 ? (external ? 7 : 3) : (external ? 0 : 2);
        this.label = label;
        this.contour = contour;
        this.dir = initialDir;
        this.x = initialX;
        this.y = initialY;
        this.indexBinary = this.binary.getIndex(this.x, this.y);
        this.indexLabel = this.labeled.getIndex(this.x - 1, this.y - 1);
        this.add(this.x, this.y);
        if (!this.searchBlack()) {
            return;
        }
        initialDir = this.dir;
        this.moveToNext();
        this.dir = this.nextDirection[this.dir];
        while (true) {
            this.searchBlack();
            if (this.x == initialX && this.y == initialY && this.dir == initialDir) {
                return;
            }
            this.add(this.x, this.y);
            this.moveToNext();
            this.dir = this.nextDirection[this.dir];
        }
    }

    private boolean searchBlack() {
        for (int i = 0; i < this.offsetsBinary.length; ++i) {
            if (this.checkBlack(this.indexBinary + this.offsetsBinary[this.dir])) {
                return true;
            }
            this.dir = (this.dir + 1) % this.rule;
        }
        return false;
    }

    private boolean checkBlack(int index) {
        if (this.binary.data[index] == 1) {
            return true;
        }
        this.binary.data[index] = -1;
        return false;
    }

    private void moveToNext() {
        this.indexBinary += this.offsetsBinary[this.dir];
        this.indexLabel += this.offsetsLabeled[this.dir];
        int a = this.indexBinary - this.binary.startIndex;
        this.x = a % this.binary.stride;
        this.y = a / this.binary.stride;
    }

    private void add(int x, int y) {
        Point2D_I32 p = this.storagePoints.grow();
        p.set(x - 1, y - 1);
        this.contour.add(p);
        this.labeled.data[this.indexLabel] = this.label;
    }
}

