/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import org.ejml.data.DenseMatrix64F;

public class RodriguesRotationJacobian {
    public DenseMatrix64F Rx = new DenseMatrix64F(3, 3);
    public DenseMatrix64F Ry = new DenseMatrix64F(3, 3);
    public DenseMatrix64F Rz = new DenseMatrix64F(3, 3);

    public void process(double x, double y, double z) {
        double theta2 = x * x + y * y + z * z;
        double theta = Math.sqrt(theta2);
        double theta4 = theta2 * theta2;
        double theta3 = theta2 * theta;
        if (theta4 == 0.0) {
            this.Rx.zero();
            this.Ry.zero();
            this.Rz.zero();
            this.Rx.set(1, 2, 1.0);
            this.Rx.set(2, 1, -1.0);
            this.Ry.set(0, 2, -1.0);
            this.Ry.set(2, 0, 1.0);
            this.Rz.set(0, 1, 1.0);
            this.Rz.set(1, 0, -1.0);
        } else {
            double s = Math.sin(theta);
            double c = Math.cos(theta);
            double cm = c - 1.0;
            double xxx = x * x * x * s / theta3 + 2.0 * cm * x * x * x / theta4;
            double xxy = x * x * y * s / theta3 + 2.0 * cm * x * x * y / theta4;
            double xxz = x * x * z * s / theta3 + 2.0 * cm * x * x * z / theta4;
            double xyy = x * y * y * s / theta3 + 2.0 * cm * x * y * y / theta4;
            double xyz = x * y * z * s / theta3 + 2.0 * cm * x * y * z / theta4;
            double xzz = x * z * z * s / theta3 + 2.0 * cm * x * z * z / theta4;
            double yyy = y * y * y * s / theta3 + 2.0 * cm * y * y * y / theta4;
            double yyz = y * y * z * s / theta3 + 2.0 * cm * y * y * z / theta4;
            double yzz = y * z * z * s / theta3 + 2.0 * cm * y * z * z / theta4;
            double zzz = z * z * z * s / theta3 + 2.0 * cm * z * z * z / theta4;
            this.Rx.data[0] = xxx - x * s / theta - 2.0 * cm * x / theta2;
            this.Rx.data[1] = xxy - x * z * c / theta2 + x * z * s / theta3 - cm * y / theta2;
            this.Rx.data[2] = xxz + x * y * c / theta2 - x * y * s / theta3 - cm * z / theta2;
            this.Rx.data[3] = xxy + x * z * c / theta2 - x * z * s / theta3 - cm * y / theta2;
            this.Rx.data[4] = xyy - x * s / theta;
            this.Rx.data[5] = xyz - x * x * c / theta2 + x * x * s / theta3 - s / theta;
            this.Rx.data[6] = xxz - x * y * c / theta2 + x * y * s / theta3 - cm * z / theta2;
            this.Rx.data[7] = xyz + x * x * c / theta2 - x * x * s / theta3 + s / theta;
            this.Rx.data[8] = xzz - x * s / theta;
            this.Ry.data[0] = xxy - y * s / theta;
            this.Ry.data[1] = xyy - y * z * c / theta2 + y * z * s / theta3 - cm * x / theta2;
            this.Ry.data[2] = xyz + y * y * c / theta2 - y * y * s / theta3 + s / theta;
            this.Ry.data[3] = xyy + y * z * c / theta2 - y * z * s / theta3 - cm * x / theta2;
            this.Ry.data[4] = yyy - y * s / theta - 2.0 * cm * y / theta2;
            this.Ry.data[5] = yyz - x * y * c / theta2 + x * y * s / theta3 - cm * z / theta2;
            this.Ry.data[6] = xyz - y * y * c / theta2 + y * y * s / theta3 - s / theta;
            this.Ry.data[7] = yyz + x * y * c / theta2 - x * y * s / theta3 - cm * z / theta2;
            this.Ry.data[8] = yzz - y * s / theta;
            this.Rz.data[0] = xxz - z * s / theta;
            this.Rz.data[1] = xyz - z * z * c / theta2 + z * z * s / theta3 - s / theta;
            this.Rz.data[2] = xzz + y * z * c / theta2 - y * z * s / theta3 - cm * x / theta2;
            this.Rz.data[3] = xyz + z * z * c / theta2 - z * z * s / theta3 + s / theta;
            this.Rz.data[4] = yyz - z * s / theta;
            this.Rz.data[5] = yzz - x * z * c / theta2 + x * z * s / theta3 - cm * y / theta2;
            this.Rz.data[6] = xzz - y * z * c / theta2 + y * z * s / theta3 - cm * x / theta2;
            this.Rz.data[7] = yzz + x * z * c / theta2 - x * z * s / theta3 - cm * y / theta2;
            this.Rz.data[8] = zzz - z * s / theta - 2.0 * cm * z / theta2;
        }
    }
}

