/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class PoseFromPairLinear6 {
    private DenseMatrix64F A = new DenseMatrix64F(1, 12);
    private SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)0, (int)0, (boolean)true, (boolean)true, (boolean)false);
    private DenseMatrix64F x = new DenseMatrix64F(12, 1);
    private Se3_F64 motion = new Se3_F64();

    public void process(List<AssociatedPair> observations, List<Point3D_F64> locations) {
        if (observations.size() != locations.size()) {
            throw new IllegalArgumentException("Number of observations and locations must match.");
        }
        if (observations.size() < 6) {
            throw new IllegalArgumentException("At least (if not more than) six points are required.");
        }
        this.setupA(observations, locations);
        this.computeTransform(this.A);
        this.massageResults();
    }

    public Se3_F64 getMotion() {
        return this.motion;
    }

    protected DenseMatrix64F getA() {
        return this.A;
    }

    private void setupA(List<AssociatedPair> observations, List<Point3D_F64> locations) {
        this.A.reshape(2 * observations.size(), 12, false);
        for (int i = 0; i < observations.size(); ++i) {
            AssociatedPair p = observations.get(i);
            Point3D_F64 loc = locations.get(i);
            Point2D_F64 pt1 = p.p1;
            Point2D_F64 pt2 = p.p2;
            int w = i * 2;
            double alpha = 1.0 / loc.z;
            this.A.set(w, 3, -pt1.x);
            this.A.set(w, 4, -pt1.y);
            this.A.set(w, 5, -1.0);
            this.A.set(w, 6, pt2.y * pt1.x);
            this.A.set(w, 7, pt2.y * pt1.y);
            this.A.set(w, 8, pt2.y);
            this.A.set(w, 9, 0.0);
            this.A.set(w, 10, -alpha);
            this.A.set(w, 11, alpha * pt2.y);
            this.A.set(++w, 0, pt1.x);
            this.A.set(w, 1, pt1.y);
            this.A.set(w, 2, 1.0);
            this.A.set(w, 6, -pt2.x * pt1.x);
            this.A.set(w, 7, -pt2.x * pt1.y);
            this.A.set(w, 8, -pt2.x);
            this.A.set(w, 9, alpha);
            this.A.set(w, 10, 0.0);
            this.A.set(w, 11, -alpha * pt2.x);
        }
    }

    private void computeTransform(DenseMatrix64F A) {
        if (!this.svd.decompose((Matrix64F)A)) {
            throw new RuntimeException("SVD failed?");
        }
        SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)this.x);
        DenseMatrix64F R = this.motion.getR();
        Vector3D_F64 T = this.motion.getT();
        System.arraycopy(this.x.data, 0, R.data, 0, 9);
        T.x = this.x.data[9];
        T.y = this.x.data[10];
        T.z = this.x.data[11];
    }

    private void massageResults() {
        DenseMatrix64F R = this.motion.getR();
        Vector3D_F64 T = this.motion.getT();
        if (!this.svd.decompose((Matrix64F)R)) {
            throw new RuntimeException("SVD Failed");
        }
        CommonOps.multTransB((RowD1Matrix64F)((RowD1Matrix64F)this.svd.getU(null, false)), (RowD1Matrix64F)((RowD1Matrix64F)this.svd.getV(null, false)), (RowD1Matrix64F)R);
        double det = CommonOps.det((DenseMatrix64F)R);
        if (det < 0.0) {
            CommonOps.scale((double)-1.0, (D1Matrix64F)R);
        }
        double b = 1.0;
        double[] s = this.svd.getSingularValues();
        for (int i = 0; i < this.svd.numberOfSingularValues(); ++i) {
            b *= s[i];
        }
        b = Math.signum(det) / Math.pow(b, 0.3333333333333333);
        GeometryMath_F64.scale((GeoTuple3D_F64)T, (double)b);
    }
}

