/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class ImageStatistics {
    public static int min(ImageUInt8 input) {
        int min = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index] & 0xFF;
                if (v >= min) continue;
                min = v;
            }
        }
        return min;
    }

    public static int max(ImageUInt8 input) {
        int max = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index] & 0xFF;
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int maxAbs(ImageUInt8 input) {
        int max = 0;
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index] & 0xFF;
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int sum(ImageUInt8 img) {
        int h = img.getHeight();
        int w = img.getWidth();
        int total = 0;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                total += img.data[index] & 0xFF;
            }
        }
        return total;
    }

    public static double mean(ImageUInt8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double variance(ImageUInt8 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)(img.data[index] & 0xFF) - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static double meanDiffSq(ImageUInt8 imgA, ImageUInt8 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = (imgA.data[indexA] & 0xFF) - (imgB.data[indexB] & 0xFF);
                total += difference * difference;
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static double meanDiffAbs(ImageUInt8 imgA, ImageUInt8 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = (imgA.data[indexA] & 0xFF) - (imgB.data[indexB] & 0xFF);
                total += Math.abs(difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static void histogram(ImageUInt8 input, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = input.data[index] & 0xFF;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static int min(ImageSInt8 input) {
        int min = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index];
                if (v >= min) continue;
                min = v;
            }
        }
        return min;
    }

    public static int max(ImageSInt8 input) {
        int max = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index];
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int maxAbs(ImageSInt8 input) {
        int max = 0;
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = Math.abs(input.data[index]);
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int sum(ImageSInt8 img) {
        int h = img.getHeight();
        int w = img.getWidth();
        int total = 0;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(ImageSInt8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double variance(ImageSInt8 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static double meanDiffSq(ImageSInt8 imgA, ImageSInt8 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = imgA.data[indexA] - imgB.data[indexB];
                total += difference * difference;
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static double meanDiffAbs(ImageSInt8 imgA, ImageSInt8 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = imgA.data[indexA] - imgB.data[indexB];
                total += Math.abs(difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static void histogram(ImageSInt8 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static int min(ImageUInt16 input) {
        int min = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index] & 0xFFFF;
                if (v >= min) continue;
                min = v;
            }
        }
        return min;
    }

    public static int max(ImageUInt16 input) {
        int max = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index] & 0xFFFF;
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int maxAbs(ImageUInt16 input) {
        int max = 0;
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index] & 0xFFFF;
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int sum(ImageUInt16 img) {
        int h = img.getHeight();
        int w = img.getWidth();
        int total = 0;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                total += img.data[index] & 0xFFFF;
            }
        }
        return total;
    }

    public static double mean(ImageUInt16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double variance(ImageUInt16 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)(img.data[index] & 0xFFFF) - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static double meanDiffSq(ImageUInt16 imgA, ImageUInt16 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = (imgA.data[indexA] & 0xFFFF) - (imgB.data[indexB] & 0xFFFF);
                total += difference * difference;
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static double meanDiffAbs(ImageUInt16 imgA, ImageUInt16 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = (imgA.data[indexA] & 0xFFFF) - (imgB.data[indexB] & 0xFFFF);
                total += Math.abs(difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static void histogram(ImageUInt16 input, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = input.data[index] & 0xFFFF;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static int min(ImageSInt16 input) {
        int min = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index];
                if (v >= min) continue;
                min = v;
            }
        }
        return min;
    }

    public static int max(ImageSInt16 input) {
        int max = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index];
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int maxAbs(ImageSInt16 input) {
        int max = 0;
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = Math.abs(input.data[index]);
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int sum(ImageSInt16 img) {
        int h = img.getHeight();
        int w = img.getWidth();
        int total = 0;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(ImageSInt16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double variance(ImageSInt16 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static double meanDiffSq(ImageSInt16 imgA, ImageSInt16 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = imgA.data[indexA] - imgB.data[indexB];
                total += difference * difference;
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static double meanDiffAbs(ImageSInt16 imgA, ImageSInt16 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = imgA.data[indexA] - imgB.data[indexB];
                total += Math.abs(difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static void histogram(ImageSInt16 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static int min(ImageSInt32 input) {
        int min = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index];
                if (v >= min) continue;
                min = v;
            }
        }
        return min;
    }

    public static int max(ImageSInt32 input) {
        int max = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = input.data[index];
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int maxAbs(ImageSInt32 input) {
        int max = 0;
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int v = Math.abs(input.data[index]);
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static int sum(ImageSInt32 img) {
        int h = img.getHeight();
        int w = img.getWidth();
        int total = 0;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(ImageSInt32 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double variance(ImageSInt32 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static double meanDiffSq(ImageSInt32 imgA, ImageSInt32 imgB) {
        long total = 0L;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = imgA.data[indexA] - imgB.data[indexB];
                total += (long)(difference * difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static double meanDiffAbs(ImageSInt32 imgA, ImageSInt32 imgB) {
        int total = 0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                int difference = imgA.data[indexA] - imgB.data[indexB];
                total += Math.abs(difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static void histogram(ImageSInt32 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static long min(ImageSInt64 input) {
        long min = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                long v = input.data[index];
                if (v >= min) continue;
                min = v;
            }
        }
        return min;
    }

    public static long max(ImageSInt64 input) {
        long max = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                long v = input.data[index];
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static long maxAbs(ImageSInt64 input) {
        long max = 0L;
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                long v = Math.abs(input.data[index]);
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static long sum(ImageSInt64 img) {
        int h = img.getHeight();
        int w = img.getWidth();
        long total = 0L;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(ImageSInt64 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double variance(ImageSInt64 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static double meanDiffSq(ImageSInt64 imgA, ImageSInt64 imgB) {
        long total = 0L;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                long difference = imgA.data[indexA] - imgB.data[indexB];
                total += difference * difference;
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static double meanDiffAbs(ImageSInt64 imgA, ImageSInt64 imgB) {
        long total = 0L;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                long difference = imgA.data[indexA] - imgB.data[indexB];
                total += Math.abs(difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static void histogram(ImageSInt64 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = (int)input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static float min(ImageFloat32 input) {
        float min = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                float v = input.data[index];
                if (!(v < min)) continue;
                min = v;
            }
        }
        return min;
    }

    public static float max(ImageFloat32 input) {
        float max = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                float v = input.data[index];
                if (!(v > max)) continue;
                max = v;
            }
        }
        return max;
    }

    public static float maxAbs(ImageFloat32 input) {
        float max = 0.0f;
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                float v = Math.abs(input.data[index]);
                if (!(v > max)) continue;
                max = v;
            }
        }
        return max;
    }

    public static float sum(ImageFloat32 img) {
        int h = img.getHeight();
        int w = img.getWidth();
        float total = 0.0f;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(ImageFloat32 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double variance(ImageFloat32 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static double meanDiffSq(ImageFloat32 imgA, ImageFloat32 imgB) {
        double total = 0.0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                float difference = imgA.data[indexA] - imgB.data[indexB];
                total += (double)(difference * difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return total / (double)(imgA.width * imgA.height);
    }

    public static double meanDiffAbs(ImageFloat32 imgA, ImageFloat32 imgB) {
        float total = 0.0f;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                float difference = imgA.data[indexA] - imgB.data[indexB];
                total += Math.abs(difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(imgA.width * imgA.height);
    }

    public static void histogram(ImageFloat32 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = (int)input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static double min(ImageFloat64 input) {
        double min = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                double v = input.data[index];
                if (!(v < min)) continue;
                min = v;
            }
        }
        return min;
    }

    public static double max(ImageFloat64 input) {
        double max = input.get(0, 0);
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                double v = input.data[index];
                if (!(v > max)) continue;
                max = v;
            }
        }
        return max;
    }

    public static double maxAbs(ImageFloat64 input) {
        double max = 0.0;
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                double v = Math.abs(input.data[index]);
                if (!(v > max)) continue;
                max = v;
            }
        }
        return max;
    }

    public static double sum(ImageFloat64 img) {
        int h = img.getHeight();
        int w = img.getWidth();
        double total = 0.0;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(ImageFloat64 img) {
        return ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double variance(ImageFloat64 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static double meanDiffSq(ImageFloat64 imgA, ImageFloat64 imgB) {
        double total = 0.0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                double difference = imgA.data[indexA] - imgB.data[indexB];
                total += difference * difference;
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return total / (double)(imgA.width * imgA.height);
    }

    public static double meanDiffAbs(ImageFloat64 imgA, ImageFloat64 imgB) {
        double total = 0.0;
        for (int y = 0; y < imgA.height; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int x = 0;
            while (x < imgA.width) {
                double difference = imgA.data[indexA] - imgB.data[indexB];
                total += Math.abs(difference);
                ++x;
                ++indexA;
                ++indexB;
            }
        }
        return total / (double)(imgA.width * imgA.height);
    }

    public static void histogram(ImageFloat64 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = (int)input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }
}

