/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.ImageSingleBand;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DenseMatrix64F;

public class StereoProcessingBase<T extends ImageSingleBand> {
    private ImageDistort<T> distortLeftRect;
    private ImageDistort<T> distortRightRect;
    private T imageLeftInput;
    private T imageRightInput;
    protected T imageLeftRect;
    protected T imageRightRect;
    protected DenseMatrix64F rect1;
    protected DenseMatrix64F rect2;
    protected DenseMatrix64F rectK;
    protected DenseMatrix64F rectR;
    protected Point3D_F64 pointRect = new Point3D_F64();
    protected double baseline;
    protected double cx;
    protected double cy;
    protected double fx;
    protected double fy;

    public StereoProcessingBase(Class<T> imageType) {
        this.imageLeftRect = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.imageRightRect = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
    }

    public void setCalibration(StereoParameters stereoParam) {
        IntrinsicParameters left = stereoParam.getLeft();
        IntrinsicParameters right = stereoParam.getRight();
        ((ImageSingleBand)this.imageLeftRect).reshape(left.getWidth(), left.getHeight());
        ((ImageSingleBand)this.imageRightRect).reshape(right.getWidth(), right.getHeight());
        RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
        Se3_F64 leftToRight = stereoParam.getRightToLeft().invert(null);
        DenseMatrix64F K1 = PerspectiveOps.calibrationMatrix(left, null);
        DenseMatrix64F K2 = PerspectiveOps.calibrationMatrix(right, null);
        rectifyAlg.process(K1, new Se3_F64(), K2, leftToRight);
        this.rect1 = rectifyAlg.getRect1();
        this.rect2 = rectifyAlg.getRect2();
        this.rectK = rectifyAlg.getCalibrationMatrix();
        this.rectR = rectifyAlg.getRectifiedRotation();
        Class imageType = ((ImageSingleBand)this.imageLeftRect).getTypeInfo().getImageClass();
        this.distortLeftRect = RectifyImageOps.rectifyImage(stereoParam.left, this.rect1, imageType);
        this.distortRightRect = RectifyImageOps.rectifyImage(stereoParam.right, this.rect2, imageType);
        this.baseline = stereoParam.getBaseline();
        this.fx = this.rectK.get(0, 0);
        this.fy = this.rectK.get(1, 1);
        this.cx = this.rectK.get(0, 2);
        this.cy = this.rectK.get(1, 2);
    }

    public void computeHomo3D(double x, double y, Point3D_F64 pointLeft) {
        this.pointRect.z = this.baseline * this.fx;
        this.pointRect.x = this.pointRect.z * (x - this.cx) / this.fx;
        this.pointRect.y = this.pointRect.z * (y - this.cy) / this.fy;
        GeometryMath_F64.multTran((DenseMatrix64F)this.rectR, (GeoTuple3D_F64)this.pointRect, (GeoTuple3D_F64)pointLeft);
    }

    public void setImages(T leftImage, T rightImage) {
        this.imageLeftInput = leftImage;
        this.imageRightInput = rightImage;
        this.distortLeftRect.apply(this.imageLeftInput, this.imageLeftRect);
        this.distortRightRect.apply(this.imageRightInput, this.imageRightRect);
    }

    public void initialize() {
    }

    public T getImageLeftRect() {
        return this.imageLeftRect;
    }

    public T getImageRightRect() {
        return this.imageRightRect;
    }

    public DenseMatrix64F getRectK() {
        return this.rectK;
    }

    public DenseMatrix64F getRect1() {
        return this.rect1;
    }

    public DenseMatrix64F getRect2() {
        return this.rect2;
    }
}

